\name{Rcmdr.Utilities}
\alias{Rcmdr.Utilities}
\alias{activeDataSet}
\alias{activeModel}
\alias{doItAndPrint}
\alias{is.valid.name}
\alias{justDoIt}
\alias{listDataSets}
\alias{listGeneralizedLinearModels}
\alias{listLinearModels}
\alias{logger}

\title{Rcmdr Utility Functions}
\description{
  These functions support writing additions to the Rcmdr package. Additional R code
  can be placed in files with file type \code{.R} in the \code{etc} subdirectory
  of the package. Add menus, submenus, and menu items by editing the file
  \code{Rcmdr-menus.txt} in the same directory.
}

\usage{
activeDataSet(dsname)
activeModel(model)
doItAndPrint(command)
justDoIt(command)
is.valid.name(x)
listDataSets(envir = .GlobalEnv, ...)
listGeneralizedLinearModels(envir = .GlobalEnv, ...)
listLinearModels(envir = .GlobalEnv, ...)
logger(command)
}

\arguments{
  \item{command}{a character string that evaluates to an R command.}
  \item{dsname}{the name of a data frame, as a character string; if not specified,
    the name of the active data set is returned. If there is no active data set,
    then an error dialog is generated.}
  \item{envir}{the environment to be searched; should generally be left at the default.}
  \item{model}{the name of a model, as a character string; if not specified,
    the name of the active model is returned. If there is no active model, then
    an error dialog is generated.}
  \item{x}{a putative R object name, as a character string.}
  \item{\dots}{Disregard.}
}

\details{
  The functions \code{doItAndPrint}, \code{justDoIt}, and \code{logger} control the 
  execution, logging, and printing of commands generated by menus and dialogs. 
  \code{logger(command)} adds \code{command} to the log window and, with the pseudo-prompt
  \code{R-cmdr>}, to the R session window. \code{justDoIt(command)} causes \code{command}
  to be executed. \code{doItAndPrint(command)} does both of these operations.
  
  The function \code{is.valid.name} checks whether a character string specifies a valid name
  for an R object, returning \code{TRUE} or \code{FALSE}.
  
  The other functions are self-explanatory.
}

\author{John Fox \email{jfox@mcmaster.ca}}

\keyword{misc}
