% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTicks.R
\name{getTicks}
\alias{getTicks}
\title{Get Ticks from Bloomberg}
\usage{
getTicks(security, eventType = "TRADE", startTime = Sys.time() - 60 * 60,
  endTime = Sys.time(), verbose = FALSE, returnAs = getOption("blpType",
  "data.frame"), tz = Sys.getenv("TZ", unset = "UTC"),
  con = defaultConnection())
}
\arguments{
\item{security}{A character variable describing a valid security ticker}

\item{eventType}{A character variable describing an event, default
is \sQuote{TRADE}.}

\item{startTime}{A Datetime object with the start time, defaults
to one hour before current time}

\item{endTime}{A Datetime object with the end time, defaults
to current time}

\item{verbose}{A boolean indicating whether verbose operation is
desired, defaults to \sQuote{FALSE}}

\item{returnAs}{A character variable describing the type of return
object; currently supported are \sQuote{data.frame} (also the default),
\sQuote{data.table}, \sQuote{fts}, \sQuote{xts} and \sQuote{zoo}}

\item{tz}{A character variable with the desired local timezone,
defaulting to the value \sQuote{TZ} environment variable, and
\sQuote{UTC} if unset}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function
\code{defaultConnection}.}
}
\value{
Depending on the value of \sQuote{returnAs}, either a
\sQuote{data.frame} or \sQuote{data.table} object also containing
non-numerical information such as condition codes, or a time-indexed
container of type \sQuote{fts}, \sQuote{xts} and \sQuote{zoo} with
a numeric matrix containing only \sQuote{value} and \sQuote{size}.
}
\description{
This function uses the Bloomberg API to retrieve ticks for the requested security.
}
\note{
Bloomberg returns condition codes as well, and may return \emph{multiple
observations for the same trade}. Eg for ES we can get \sQuote{AS} or
\sQuote{AB} for aggressor buy or sell, \sQuote{OR} for an order participating in the
matching event, or a \sQuote{TSUM} trade summary.  Note that this implies
double-counting.  There may be an option for this in the API.
}
\examples{
\dontrun{
  res <- getTicks("ES1 Index")
  str(res)
  head(res, 20)
  res <- getTicks("ES1 Index", returnAs="data.table")
  str(res)
  head(res, 20)
}
}
\author{
Dirk Eddelbuettel
}

