% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy_k.R
\name{entropy_k}
\alias{entropy_k}
\title{Calculate Keyfitz's entropy from a trajectory of age-specific survivorship}
\usage{
entropy_k(lx, trapeze = FALSE)
}
\arguments{
\item{lx}{Survivorship trajectory (a vector of monotonically-declining values
in the interval [0,1]).}

\item{trapeze}{A logical argument indicating whether the composite trapezoid
approximation should be used for approximating the definite integral.}
}
\value{
Keyfitz's life table entropy.
}
\description{
Calculate Keyfitz's entropy from a vector of age-specific survivorship (\code{lx}).
}
\section{Warning}{

Note that this function may produce unexpected results if used on partial
survivorship trajectories. In addition, it is sensitive to the length of the
survivorship vector. We direct users to the function `\code{\link{shape_surv}}`
which is relatively robust to these issues.
}

\examples{
data(mpm1)

# derive lx trajectory, starting from stage 2
lx <- mpm_to_lx(mpm1$matU, start = 2)

# calculate Keyfitz' entropy
entropy_k(lx)

# use trapezoid approximation for definite integral
entropy_k(lx, trapeze = TRUE)

}
\references{
Keyfitz, N. 1977. Applied Mathematical Demography. New York:
  Wiley.

  Demetrius, L., & Gundlach, V. M. 2014. Directionality theory and
  the entropic principle of natural selection. Entropy 16: 5428-5522.
}
\seealso{
Other life history traits: 
\code{\link{entropy_d}()},
\code{\link{gen_time}()},
\code{\link{life_expect_mean}()},
\code{\link{longevity}()},
\code{\link{net_repro_rate}()},
\code{\link{repro_maturity}},
\code{\link{shape_rep}()},
\code{\link{shape_surv}()}
}
\author{
Owen R. Jones <jones@biology.sdu.dk>

Roberto Salguero-Gomez <rob.salguero@zoo.ox.ac.uk>
}
\concept{life history traits}
