/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class DMNBtext
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
TechnicalInformationHandler,
UpdateableClassifier {
    static final long serialVersionUID = 5932177450183457085L;
    protected int m_NumIterations = 1;
    protected boolean m_BinaryWord = true;
    int m_numClasses = -1;
    protected Instances m_headerInfo;
    DNBBinary[] m_binaryClassifiers = null;

    public String globalInfo() {
        return "Class for building and using a Discriminative Multinomial Naive Bayes classifier. For more information see,\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "The core equation for this classifier:\n\n" + "P[Ci|D] = (P[D|Ci] x P[Ci]) / P[D] (Bayes rule)\n\n" + "where Ci is class i and D is a document.";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Jiang Su,Harry Zhang,Charles X. Ling,Stan Matwin");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2008");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Discriminative Parameter Learning for Bayesian Networks");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "ICML 2008'");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        this.m_binaryClassifiers = new DNBBinary[instances2.numClasses()];
        this.m_numClasses = instances2.numClasses();
        this.m_headerInfo = new Instances(instances2, 0);
        for (int i = 0; i < instances2.numClasses(); ++i) {
            this.m_binaryClassifiers[i] = new DNBBinary();
            this.m_binaryClassifiers[i].setTargetClass(i);
            this.m_binaryClassifiers[i].initClassifier(instances2);
        }
        if (instances2.numInstances() == 0) {
            return;
        }
        Random random = new Random();
        for (int i = 0; i < this.m_NumIterations; ++i) {
            for (int j = 0; j < instances2.numInstances(); ++j) {
                this.updateClassifier(instances2.instance(j));
            }
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (this.m_numClasses == 2) {
            this.m_binaryClassifiers[0].updateClassifier(instance);
        } else {
            for (int i = 0; i < instance.numClasses(); ++i) {
                this.m_binaryClassifiers[i].updateClassifier(instance);
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_numClasses == 2) {
            return this.m_binaryClassifiers[0].distributionForInstance(instance);
        }
        double[] dArray = new double[instance.numClasses()];
        for (int i = 0; i < this.m_numClasses; ++i) {
            dArray[i] = this.m_binaryClassifiers[i].getLogProbForTargetClass(instance);
        }
        double d = dArray[Utils.maxIndex(dArray)];
        for (int i = 0; i < this.m_numClasses; ++i) {
            dArray[i] = Math.exp(dArray[i] - d);
        }
        try {
            Utils.normalize(dArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return dArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("The log ratio of two conditional probabilities of a word w_i: log(p(w_i)|+)/p(w_i)|-)) in decent order based on their absolute values\n");
        stringBuffer.append("Can be used to measure the discriminative power of each word.\n");
        if (this.m_numClasses == 2) {
            return stringBuffer.append(this.m_binaryClassifiers[0].toString()).toString();
        }
        for (int i = 0; i < this.m_numClasses; ++i) {
            stringBuffer.append(i + " against the rest classes\n");
            stringBuffer.append(this.m_binaryClassifiers[i].toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('I', stringArray);
        if (string.length() != 0) {
            this.setNumIterations(Integer.parseInt(string));
        } else {
            this.setNumIterations(this.m_NumIterations);
        }
        string = Utils.getOption('B', stringArray);
        if (string.length() != 0) {
            this.setBinaryWord(Boolean.parseBoolean(string));
        } else {
            this.setBinaryWord(this.m_BinaryWord);
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[4];
        int n = 0;
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.getNumIterations();
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.getBinaryWord();
        return stringArray;
    }

    public String numIterationsTipText() {
        return "The number of iterations that the classifier will scan the training data";
    }

    public void setNumIterations(int n) {
        this.m_NumIterations = n;
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public String binaryWordTipText() {
        return " whether ingore the frequency information in data";
    }

    public void setBinaryWord(boolean bl) {
        this.m_BinaryWord = bl;
    }

    public boolean getBinaryWord() {
        return this.m_BinaryWord;
    }

    public String getRevision() {
        return "$Revision: 1.0";
    }

    public static void main(String[] stringArray) {
        DMNBtext dMNBtext = new DMNBtext();
        DMNBtext.runClassifier(dMNBtext, stringArray);
    }

    public class DNBBinary
    implements Serializable {
        private double[][] m_perWordPerClass;
        private double[] m_wordsPerClass;
        int m_classIndex = -1;
        private double[] m_classDistribution;
        private int m_numAttributes;
        private int m_targetClass = -1;
        private double m_WordLaplace = 1.0;
        private double[] m_coefficient;
        private double m_classRatio;
        private double m_wordRatio;

        public void initClassifier(Instances instances) throws Exception {
            this.m_numAttributes = instances.numAttributes();
            this.m_perWordPerClass = new double[2][this.m_numAttributes];
            this.m_coefficient = new double[this.m_numAttributes];
            this.m_wordsPerClass = new double[2];
            this.m_classDistribution = new double[2];
            this.m_WordLaplace = Math.log(this.m_numAttributes);
            this.m_classIndex = instances.classIndex();
            for (int i = 0; i < 2; ++i) {
                this.m_classDistribution[i] = 1.0;
                this.m_wordsPerClass[i] = this.m_WordLaplace * (double)this.m_numAttributes;
                Arrays.fill(this.m_perWordPerClass[i], this.m_WordLaplace);
            }
        }

        public void updateClassifier(Instance instance) throws Exception {
            int n = 0;
            if (instance.value(instance.classIndex()) != (double)this.m_targetClass) {
                n = 1;
            }
            double d = 1.0 - this.distributionForInstance(instance)[n];
            double d2 = d * instance.weight();
            for (int i = 0; i < instance.numValues(); ++i) {
                if (instance.index(i) == this.m_classIndex) continue;
                if (DMNBtext.this.m_BinaryWord) {
                    if (instance.valueSparse(i) > 0.0) {
                        int n2 = n;
                        this.m_wordsPerClass[n2] = this.m_wordsPerClass[n2] + d2;
                        double[] dArray = this.m_perWordPerClass[n];
                        int n3 = instance.index(i);
                        dArray[n3] = dArray[n3] + d2;
                    }
                } else {
                    double d3 = instance.valueSparse(i) * d2;
                    int n4 = n;
                    this.m_wordsPerClass[n4] = this.m_wordsPerClass[n4] + d3;
                    double[] dArray = this.m_perWordPerClass[n];
                    int n5 = instance.index(i);
                    dArray[n5] = dArray[n5] + d3;
                }
                this.m_coefficient[instance.index((int)i)] = Math.log(this.m_perWordPerClass[0][instance.index(i)] / this.m_perWordPerClass[1][instance.index(i)]);
            }
            this.m_wordRatio = Math.log(this.m_wordsPerClass[0] / this.m_wordsPerClass[1]);
            int n6 = n;
            this.m_classDistribution[n6] = this.m_classDistribution[n6] + d2;
            this.m_classRatio = Math.log(this.m_classDistribution[0] / this.m_classDistribution[1]);
        }

        public double getLogProbForTargetClass(Instance instance) throws Exception {
            double d = this.m_classRatio;
            for (int i = 0; i < instance.numValues(); ++i) {
                if (instance.index(i) == this.m_classIndex) continue;
                if (DMNBtext.this.m_BinaryWord) {
                    if (!(instance.valueSparse(i) > 0.0)) continue;
                    d += this.m_coefficient[instance.index(i)] - this.m_wordRatio;
                    continue;
                }
                d += instance.valueSparse(i) * (this.m_coefficient[instance.index(i)] - this.m_wordRatio);
            }
            return d;
        }

        public double[] distributionForInstance(Instance instance) throws Exception {
            double[] dArray = new double[2];
            double d = this.getLogProbForTargetClass(instance);
            if (d > 709.0) {
                dArray[0] = 1.0;
            } else {
                d = Math.exp(d);
                dArray[0] = d / (1.0 + d);
            }
            dArray[1] = 1.0 - dArray[0];
            return dArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n");
            TreeMap<Double, String> treeMap = new TreeMap<Double, String>();
            double[] dArray = new double[this.m_numAttributes];
            for (int i = 0; i < this.m_numAttributes; ++i) {
                if (i == DMNBtext.this.m_headerInfo.classIndex()) continue;
                String string = DMNBtext.this.m_headerInfo.attribute(i).name() + ": " + this.m_coefficient[i];
                treeMap.put(-1.0 * Math.abs(this.m_coefficient[i]), string);
            }
            Iterator iterator = treeMap.values().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        public void setTargetClass(int n) {
            this.m_targetClass = n;
        }

        public int getTargetClass() {
            return this.m_targetClass;
        }
    }
}

