/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import weka.core.Capabilities;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ConverterUtils;
import weka.core.converters.FileSourcedConverter;
import weka.gui.ExtensionFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -5373058011025481738L;
    public static final int UNHANDLED_DIALOG = 0;
    public static final int LOADER_DIALOG = 1;
    public static final int SAVER_DIALOG = 2;
    protected ConverterFileChooser m_Self = this;
    protected static Vector<ExtensionFileFilter> m_LoaderFileFilters;
    protected static Vector<ExtensionFileFilter> m_SaverFileFilters;
    protected int m_DialogType;
    protected Object m_CurrentConverter;
    protected JButton m_ConfigureButton;
    protected PropertyChangeListener m_Listener;
    protected FileFilter m_LastFilter;
    protected Capabilities m_CapabilitiesFilter;
    protected boolean m_OverwriteWarning = true;
    protected boolean m_FileMustExist = true;
    protected boolean m_CoreConvertersOnly = false;

    public ConverterFileChooser() {
    }

    public ConverterFileChooser(File file) {
        super(file);
    }

    public ConverterFileChooser(String string) {
        super(string);
    }

    protected Vector<ExtensionFileFilter> filterNonCoreLoaderFileFilters(Vector<ExtensionFileFilter> vector) {
        Vector<ExtensionFileFilter> vector2;
        if (!this.getCoreConvertersOnly()) {
            vector2 = vector;
        } else {
            vector2 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                ExtensionFileFilter extensionFileFilter = vector.get(i);
                AbstractFileLoader abstractFileLoader = ConverterUtils.getLoaderForExtension(extensionFileFilter.getExtensions()[0]);
                if (!ConverterUtils.isCoreFileLoader(abstractFileLoader.getClass().getName())) continue;
                vector2.add(extensionFileFilter);
            }
        }
        return vector2;
    }

    protected Vector<ExtensionFileFilter> filterNonCoreSaverFileFilters(Vector<ExtensionFileFilter> vector) {
        Vector<ExtensionFileFilter> vector2;
        if (!this.getCoreConvertersOnly()) {
            vector2 = vector;
        } else {
            vector2 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                ExtensionFileFilter extensionFileFilter = vector.get(i);
                AbstractFileSaver abstractFileSaver = ConverterUtils.getSaverForExtension(extensionFileFilter.getExtensions()[0]);
                if (!ConverterUtils.isCoreFileSaver(abstractFileSaver.getClass().getName())) continue;
                vector2.add(extensionFileFilter);
            }
        }
        return vector2;
    }

    protected Vector<ExtensionFileFilter> filterSaverFileFilters(Vector<ExtensionFileFilter> vector) {
        Vector<ExtensionFileFilter> vector2;
        if (this.m_CapabilitiesFilter == null) {
            vector2 = vector;
        } else {
            vector2 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                ExtensionFileFilter extensionFileFilter = vector.get(i);
                AbstractFileSaver abstractFileSaver = ConverterUtils.getSaverForExtension(extensionFileFilter.getExtensions()[0]);
                if (!abstractFileSaver.getCapabilities().supports(this.m_CapabilitiesFilter)) continue;
                vector2.add(extensionFileFilter);
            }
        }
        return vector2;
    }

    protected static void initFilters(boolean bl, Vector<String> vector) {
        if (bl) {
            m_LoaderFileFilters = new Vector();
        } else {
            m_SaverFileFilters = new Vector();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ExtensionFileFilter extensionFileFilter;
            int n;
            String string;
            String[] stringArray;
            FileSourcedConverter fileSourcedConverter;
            Class<?> clazz;
            String string2 = vector.get(i);
            try {
                clazz = Class.forName(string2);
                fileSourcedConverter = (FileSourcedConverter)clazz.newInstance();
                stringArray = fileSourcedConverter.getFileExtensions();
                string = fileSourcedConverter.getFileDescription();
            }
            catch (Exception exception) {
                clazz = null;
                fileSourcedConverter = null;
                stringArray = new String[]{};
                string = "";
            }
            if (fileSourcedConverter == null) continue;
            if (bl) {
                for (n = 0; n < stringArray.length; ++n) {
                    extensionFileFilter = new ExtensionFileFilter(stringArray[n], string + " (*" + stringArray[n] + ")");
                    m_LoaderFileFilters.add(extensionFileFilter);
                }
                continue;
            }
            for (n = 0; n < stringArray.length; ++n) {
                extensionFileFilter = new ExtensionFileFilter(stringArray[n], string + " (*" + stringArray[n] + ")");
                m_SaverFileFilters.add(extensionFileFilter);
            }
        }
    }

    protected void initGUI(int n) {
        boolean bl = this.isAcceptAllFileFilterUsed();
        this.resetChoosableFileFilters();
        this.setAcceptAllFileFilterUsed(bl);
        Vector<ExtensionFileFilter> vector = n == 1 ? this.filterNonCoreLoaderFileFilters(m_LoaderFileFilters) : this.filterSaverFileFilters(this.filterNonCoreSaverFileFilters(m_SaverFileFilters));
        for (int i = 0; i < vector.size(); ++i) {
            this.addChoosableFileFilter(vector.get(i));
        }
        if (vector.size() > 0) {
            if (this.m_LastFilter == null || !vector.contains(this.m_LastFilter)) {
                this.setFileFilter(vector.get(0));
            } else {
                this.setFileFilter(this.m_LastFilter);
            }
        }
        if (this.m_Listener != null) {
            this.removePropertyChangeListener(this.m_Listener);
        }
        this.m_Listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("fileFilterChanged")) {
                    ConverterFileChooser.this.updateCurrentConverter();
                }
            }
        };
        this.addPropertyChangeListener(this.m_Listener);
        this.updateCurrentConverter();
    }

    public void setCapabilitiesFilter(Capabilities capabilities) {
        this.m_CapabilitiesFilter = (Capabilities)capabilities.clone();
    }

    public Capabilities getCapabilitiesFilter() {
        if (this.m_CapabilitiesFilter != null) {
            return (Capabilities)this.m_CapabilitiesFilter.clone();
        }
        return null;
    }

    public void setOverwriteWarning(boolean bl) {
        this.m_OverwriteWarning = bl;
    }

    public boolean getOverwriteWarning() {
        return this.m_OverwriteWarning;
    }

    public void setFileMustExist(boolean bl) {
        this.m_FileMustExist = bl;
    }

    public boolean getFileMustExist() {
        return this.m_FileMustExist;
    }

    public void setCoreConvertersOnly(boolean bl) {
        this.m_CoreConvertersOnly = bl;
    }

    public boolean getCoreConvertersOnly() {
        return this.m_CoreConvertersOnly;
    }

    @Override
    public int showDialog(Component component, String string) {
        if (this.m_DialogType == 0) {
            throw new IllegalStateException("Either use showOpenDialog or showSaveDialog!");
        }
        return super.showDialog(component, string);
    }

    @Override
    public int showOpenDialog(Component component) {
        String[] stringArray;
        String string;
        this.m_DialogType = 1;
        this.m_CurrentConverter = null;
        this.initGUI(1);
        int n = super.showOpenDialog(component);
        this.m_DialogType = 0;
        this.removePropertyChangeListener(this.m_Listener);
        if (n == 0 && this.getSelectedFile().isFile() && this.getFileFilter() instanceof ExtensionFileFilter && !(string = this.getSelectedFile().getAbsolutePath()).endsWith((stringArray = ((ExtensionFileFilter)this.getFileFilter()).getExtensions())[0])) {
            string = string + stringArray[0];
            this.setSelectedFile(new File(string));
        }
        if (n == 0 && this.getFileMustExist() && this.getSelectedFile().isFile() && !this.getSelectedFile().exists()) {
            int n2 = JOptionPane.showConfirmDialog(component, "The file '" + this.getSelectedFile() + "' does not exist - please select again!");
            n = n2 == 0 ? this.showOpenDialog(component) : 1;
        }
        if (n == 0) {
            this.m_LastFilter = this.getFileFilter();
            this.configureCurrentConverter(1);
        }
        return n;
    }

    @Override
    public int showSaveDialog(Component component) {
        String[] stringArray;
        String string;
        this.m_DialogType = 2;
        this.m_CurrentConverter = null;
        this.initGUI(2);
        boolean bl = this.isAcceptAllFileFilterUsed();
        FileFilter fileFilter = this.getFileFilter();
        File file = this.getSelectedFile();
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(fileFilter);
        this.setSelectedFile(file);
        int n = super.showSaveDialog(component);
        if (n == 0 && this.getFileFilter() instanceof ExtensionFileFilter && !(string = this.getSelectedFile().getAbsolutePath()).endsWith((stringArray = ((ExtensionFileFilter)this.getFileFilter()).getExtensions())[0])) {
            string = string + stringArray[0];
            this.setSelectedFile(new File(string));
        }
        fileFilter = this.getFileFilter();
        file = this.getSelectedFile();
        this.setAcceptAllFileFilterUsed(bl);
        this.setFileFilter(fileFilter);
        this.setSelectedFile(file);
        this.m_DialogType = 0;
        this.removePropertyChangeListener(this.m_Listener);
        if (n == 0 && this.getOverwriteWarning() && this.getSelectedFile().exists()) {
            int n2 = JOptionPane.showConfirmDialog(component, "The file '" + this.getSelectedFile() + "' already exists - overwrite it?");
            n = n2 == 0 ? 0 : (n2 == 1 ? this.showSaveDialog(component) : 1);
        }
        if (n == 0) {
            this.m_LastFilter = this.getFileFilter();
            this.configureCurrentConverter(2);
        }
        return n;
    }

    public AbstractFileLoader getLoader() {
        this.configureCurrentConverter(1);
        if (this.m_CurrentConverter instanceof AbstractFileSaver) {
            return null;
        }
        return (AbstractFileLoader)this.m_CurrentConverter;
    }

    public AbstractFileSaver getSaver() {
        this.configureCurrentConverter(2);
        if (this.m_CurrentConverter instanceof AbstractFileLoader) {
            return null;
        }
        return (AbstractFileSaver)this.m_CurrentConverter;
    }

    protected void updateCurrentConverter() {
        if (this.getFileFilter() == null) {
            return;
        }
        if (!this.isAcceptAllFileFilterUsed()) {
            String[] stringArray = ((ExtensionFileFilter)this.getFileFilter()).getExtensions();
            EnvironmentHandler environmentHandler = this.m_DialogType == 1 ? ConverterUtils.getLoaderForExtension(stringArray[0]) : ConverterUtils.getSaverForExtension(stringArray[0]);
            try {
                if (this.m_CurrentConverter == null) {
                    this.m_CurrentConverter = environmentHandler;
                } else if (!this.m_CurrentConverter.getClass().equals(environmentHandler.getClass())) {
                    this.m_CurrentConverter = environmentHandler;
                }
            }
            catch (Exception exception) {
                this.m_CurrentConverter = null;
                exception.printStackTrace();
            }
        } else {
            this.m_CurrentConverter = null;
        }
    }

    protected void configureCurrentConverter(int n) {
        if (this.getSelectedFile() == null || this.getSelectedFile().isDirectory()) {
            return;
        }
        String string = this.getSelectedFile().getAbsolutePath();
        if (this.m_CurrentConverter == null) {
            if (n == 1) {
                this.m_CurrentConverter = ConverterUtils.getLoaderForFile(string);
            } else if (n == 2) {
                this.m_CurrentConverter = ConverterUtils.getSaverForFile(string);
            } else {
                throw new IllegalStateException("Cannot determine loader/saver!");
            }
            if (this.m_CurrentConverter == null) {
                return;
            }
        }
        try {
            File file = ((FileSourcedConverter)this.m_CurrentConverter).retrieveFile();
            if (file == null || !file.getAbsolutePath().equals(string)) {
                ((FileSourcedConverter)this.m_CurrentConverter).setFile(new File(string));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        ConverterFileChooser converterFileChooser = new ConverterFileChooser();
        int n = converterFileChooser.showOpenDialog(null);
        if (n == 0) {
            AbstractFileLoader abstractFileLoader = converterFileChooser.getLoader();
            Instances instances = abstractFileLoader.getDataSet();
            n = converterFileChooser.showSaveDialog(null);
            if (n == 0) {
                AbstractFileSaver abstractFileSaver = converterFileChooser.getSaver();
                abstractFileSaver.setInstances(instances);
                abstractFileSaver.writeBatch();
            } else {
                System.out.println("Saving aborted!");
            }
        } else {
            System.out.println("Loading aborted!");
        }
    }

    static {
        ConverterFileChooser.initFilters(true, ConverterUtils.getFileLoaders());
        ConverterFileChooser.initFilters(false, ConverterUtils.getFileSavers());
    }
}

