/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stemmers;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.ClassDiscovery;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.stemmers.Stemmer;
import weka.core.stemmers.Stemming;
import weka.gui.GenericObjectEditor;

public class SnowballStemmer
implements Stemmer,
OptionHandler {
    static final long serialVersionUID = -6111170431963015178L;
    public static final String PACKAGE = "org.tartarus.snowball";
    public static final String PACKAGE_EXT = "org.tartarus.snowball.ext";
    protected static final String SNOWBALL_PROGRAM = "org.tartarus.snowball.SnowballProgram";
    protected static boolean m_Present = false;
    protected static Vector m_Stemmers;
    protected Object m_Stemmer;
    protected transient Method m_StemMethod;
    protected transient Method m_SetCurrentMethod;
    protected transient Method m_GetCurrentMethod;

    public SnowballStemmer() {
        this("porter");
        SnowballStemmer.initStemmers();
    }

    public SnowballStemmer(String string) {
        this.setStemmer(string);
    }

    private static void checkForSnowball() {
        try {
            Class.forName(SNOWBALL_PROGRAM);
            m_Present = true;
        }
        catch (Exception exception) {
            m_Present = false;
        }
    }

    public String globalInfo() {
        return "A wrapper class for the Snowball stemmers. Only available if the Snowball classes are in the classpath.\nIf the class discovery is not dynamic, i.e., the property 'UseDynamic' in the props file 'weka/gui/GenericPropertiesCreator.props' is 'false', then the property 'org.tartarus.snowball.SnowballProgram' in the 'weka/gui/GenericObjectEditor.props' file has to be uncommented as well. If necessary you have to discover and fill in the snowball stemmers manually. You can use the 'weka.core.ClassDiscovery' for this:\n  java weka.core.ClassDiscovery org.tartarus.snowball.SnowballProgram org.tartarus.snowball.ext\n\nFor more information visit these web sites:\n  http://weka.wiki.sourceforge.net/Stemmers\n  http://snowball.tartarus.org/\n";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe name of the snowball stemmer (default 'porter').\n\tavailable stemmers:\n" + SnowballStemmer.getStemmerList(65, "\t   "), "S", 1, "-S <name>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setStemmer(string);
        } else {
            this.setStemmer("porter");
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getStemmer() != null) {
            vector.add("-S");
            vector.add("" + this.getStemmer());
        }
        return vector.toArray(new String[vector.size()]);
    }

    private static String getStemmerName(String string) {
        return string.replaceAll(".*\\.", "").replaceAll("Stemmer$", "");
    }

    private static String getStemmerClassname(String string) {
        return "org.tartarus.snowball.ext." + string + "Stemmer";
    }

    private static void initStemmers() {
        if (m_Stemmers != null) {
            return;
        }
        m_Stemmers = new Vector();
        if (!m_Present) {
            return;
        }
        Vector vector = GenericObjectEditor.getClassnames(SNOWBALL_PROGRAM);
        if (vector.size() == 0) {
            vector = ClassDiscovery.find(SNOWBALL_PROGRAM, PACKAGE_EXT);
            for (int i = 0; i < vector.size(); ++i) {
                m_Stemmers.add(SnowballStemmer.getStemmerName(vector.get(i).toString()));
            }
        }
    }

    public static boolean isPresent() {
        return m_Present;
    }

    public static Enumeration listStemmers() {
        SnowballStemmer.initStemmers();
        return m_Stemmers.elements();
    }

    private static String getStemmerList(int n, String string) {
        String string2 = "";
        String string3 = "";
        Enumeration enumeration = SnowballStemmer.listStemmers();
        while (enumeration.hasMoreElements()) {
            String string4 = enumeration.nextElement().toString();
            if (string3.length() > 0) {
                string3 = string3 + ", ";
            }
            if (n > 0 && string3.length() + string4.length() > n) {
                string2 = string2 + string + string3 + "\n";
                string3 = "";
            }
            string3 = string3 + string4;
        }
        if (string3.length() > 0) {
            string2 = string2 + string + string3 + "\n";
        }
        return string2;
    }

    public String getStemmer() {
        SnowballStemmer.initStemmers();
        if (this.m_Stemmer == null) {
            return null;
        }
        return SnowballStemmer.getStemmerName(this.m_Stemmer.getClass().getName());
    }

    public void setStemmer(String string) {
        SnowballStemmer.initStemmers();
        if (m_Stemmers.contains(string)) {
            try {
                Class<?> clazz = Class.forName(SnowballStemmer.getStemmerClassname(string));
                this.m_Stemmer = clazz.newInstance();
                Class[] classArray = new Class[]{};
                this.m_StemMethod = clazz.getMethod("stem", classArray);
                classArray = new Class[]{String.class};
                this.m_SetCurrentMethod = clazz.getMethod("setCurrent", classArray);
                classArray = new Class[]{};
                this.m_GetCurrentMethod = clazz.getMethod("getCurrent", classArray);
            }
            catch (Exception exception) {
                System.out.println("Error initializing stemmer '" + string + "'!" + exception.getMessage());
                this.m_Stemmer = null;
            }
        } else {
            System.err.println("Stemmer '" + string + "' unknown!");
            this.m_Stemmer = null;
        }
    }

    public String stemmerTipText() {
        return "The Snowball stemmer to use, available: " + SnowballStemmer.getStemmerList(0, "");
    }

    public String stem(String string) {
        String string2;
        if (this.m_Stemmer == null) {
            string2 = new String(string);
        } else {
            if (this.m_SetCurrentMethod == null) {
                this.setStemmer(this.getStemmer());
            }
            try {
                Object[] objectArray = new Object[]{string};
                this.m_SetCurrentMethod.invoke(this.m_Stemmer, objectArray);
                objectArray = new Object[]{};
                this.m_StemMethod.invoke(this.m_Stemmer, objectArray);
                objectArray = new Object[]{};
                string2 = (String)this.m_GetCurrentMethod.invoke(this.m_Stemmer, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string2 = string;
            }
        }
        return string2;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string + " " + Utils.joinOptions(this.getOptions());
        return string.trim();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4648 $");
    }

    public static void main(String[] stringArray) {
        try {
            Stemming.useStemmer(new SnowballStemmer(), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        SnowballStemmer.checkForSnowball();
    }
}

