/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import weka.associations.AbstractAssociator;
import weka.associations.gsp.Element;
import weka.associations.gsp.Sequence;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class GeneralizedSequentialPatterns
extends AbstractAssociator
implements OptionHandler,
TechnicalInformationHandler {
    private static final long serialVersionUID = -4119691320812254676L;
    protected double m_MinSupport;
    protected int m_DataSeqID;
    protected Instances m_OriginalDataSet;
    protected FastVector m_AllSequentialPatterns;
    protected int m_Cycles;
    protected String m_CycleStart;
    protected String m_CycleEnd;
    protected String m_AlgorithmStart;
    protected String m_FilterAttributes;
    protected FastVector m_FilterAttrVector;
    protected boolean m_Debug = false;

    public GeneralizedSequentialPatterns() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Class implementing a GSP algorithm for discovering sequential patterns in a sequential data set.\nThe attribute identifying the distinct data sequences contained in the set can be determined by the respective option. Furthermore, the set of output results can be restricted by specifying one or more attributes that have to be contained in each element/itemset of a sequence.\n\nFor further information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.PROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Ramakrishnan Srikant and Rakesh Agrawal");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Mining Sequential Patterns: Generalizations and Performance Improvements");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Database Technology EDBT '96");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1996");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tIf set, algorithm is run in debug mode and\n\tmay output additional info to the console", "D", 0, "-D"));
        vector.addElement(new Option("\tThe miminum support threshold.\n\t(default: 0.9)", "S", 1, "-S <minimum support threshold>"));
        vector.addElement(new Option("\tThe attribute number representing the data sequence ID.\n\t(default: 0)", "I", 1, "-I <attribute number representing the data sequence ID"));
        vector.addElement(new Option("\tThe attribute numbers used for result filtering.\n\t(default: -1)", "F", 1, "-F <attribute numbers used for result filtering"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        this.setDebug(Utils.getFlag('D', stringArray));
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setMinSupport(Double.parseDouble(string));
        }
        if ((string = Utils.getOption('I', stringArray)).length() != 0) {
            this.setDataSeqID(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('F', stringArray)).length() != 0) {
            this.setFilterAttributes(string);
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getDebug()) {
            vector.add("-D");
        }
        vector.add("-S");
        vector.add("" + this.getMinSupport());
        vector.add("-I");
        vector.add("" + this.getDataSeqID());
        vector.add("-F");
        vector.add(this.getFilterAttributes());
        return vector.toArray(new String[vector.size()]);
    }

    protected void resetOptions() {
        this.m_MinSupport = 0.9;
        this.m_DataSeqID = 0;
        this.m_FilterAttributes = "-1";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void buildAssociations(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.m_AllSequentialPatterns = new FastVector();
        this.m_Cycles = 0;
        this.m_FilterAttrVector = new FastVector();
        this.m_AlgorithmStart = this.getTimeAndDate();
        this.m_OriginalDataSet = new Instances(instances);
        this.extractFilterAttributes(this.m_FilterAttributes);
        this.findFrequentSequences();
    }

    protected int calcFreqSequencesTotal() {
        int n = 0;
        Enumeration enumeration = this.m_AllSequentialPatterns.elements();
        while (enumeration.hasMoreElements()) {
            FastVector fastVector = (FastVector)enumeration.nextElement();
            n += fastVector.size();
        }
        return n;
    }

    protected FastVector extractDataSequences(Instances instances, int n) {
        FastVector fastVector = new FastVector();
        int n2 = 0;
        int n3 = 0;
        Attribute attribute = instances.attribute(n);
        for (int i = 0; i < attribute.numValues(); ++i) {
            double d = instances.instance(n2).value(n);
            while (n3 < instances.numInstances() && d == instances.instance(n3).value(n)) {
                ++n3;
            }
            Instances instances2 = new Instances(instances, n2, n3 - n2);
            instances2.deleteAttributeAt(n);
            fastVector.addElement(instances2);
            n2 = n3;
        }
        return fastVector;
    }

    public void extractFilterAttributes(String string) {
        String string2 = string.trim();
        while (!string2.equals("")) {
            int n = string2.indexOf(44);
            if (n != -1) {
                String string3 = string2.substring(0, n);
                string2 = string2.substring(n + 1).trim();
                this.m_FilterAttrVector.addElement(Integer.decode(string3));
                continue;
            }
            this.m_FilterAttrVector.addElement(Integer.decode(string2));
            break;
        }
    }

    protected void findFrequentSequences() throws CloneNotSupportedException {
        this.m_CycleStart = this.getTimeAndDate();
        Instances instances = this.m_OriginalDataSet;
        FastVector fastVector = this.extractDataSequences(this.m_OriginalDataSet, this.m_DataSeqID);
        long l = Math.round(this.m_MinSupport * (double)fastVector.size());
        instances.deleteAttributeAt(0);
        FastVector fastVector2 = Element.getOneElements(instances);
        this.m_Cycles = 1;
        FastVector fastVector3 = Sequence.oneElementsToSequences(fastVector2);
        Sequence.updateSupportCount(fastVector3, fastVector);
        fastVector3 = Sequence.deleteInfrequentSequences(fastVector3, l);
        this.m_CycleEnd = this.getTimeAndDate();
        if (fastVector3.size() == 0) {
            return;
        }
        while (fastVector3.size() > 0) {
            this.m_CycleStart = this.getTimeAndDate();
            this.m_AllSequentialPatterns.addElement(fastVector3.copy());
            FastVector fastVector4 = fastVector3;
            fastVector3 = Sequence.aprioriGen(fastVector4);
            Sequence.updateSupportCount(fastVector3, fastVector);
            fastVector3 = Sequence.deleteInfrequentSequences(fastVector3, l);
            this.m_CycleEnd = this.getTimeAndDate();
            if (this.getDebug()) {
                System.out.println("Cycle " + this.m_Cycles + " from " + this.m_CycleStart + " to " + this.m_CycleEnd);
            }
            ++this.m_Cycles;
        }
    }

    public String dataSeqIDTipText() {
        return "The attribute number representing the data sequence ID.";
    }

    public int getDataSeqID() {
        return this.m_DataSeqID;
    }

    public void setDataSeqID(int n) {
        this.m_DataSeqID = n;
    }

    public String filterAttributesTipText() {
        return "The attribute numbers (eg \"0, 1\") used for result filtering; only sequences containing the specified attributes in each of their elements/itemsets will be output; -1 prints all.";
    }

    public String getFilterAttributes() {
        return this.m_FilterAttributes;
    }

    public void setFilterAttributes(String string) {
        this.m_FilterAttributes = string;
    }

    public String minSupportTipText() {
        return "Minimum support threshold.";
    }

    public double getMinSupport() {
        return this.m_MinSupport;
    }

    public void setMinSupport(double d) {
        this.m_MinSupport = d;
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "If set to true, algorithm may output additional info to the console.";
    }

    protected String getTimeAndDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    public String getAlgorithmStart() {
        return this.m_AlgorithmStart;
    }

    public String getCycleStart() {
        return this.m_CycleStart;
    }

    public String getCycleEnd() {
        return this.m_CycleEnd;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GeneralizedSequentialPatterns\n");
        stringBuffer.append("=============================\n\n");
        stringBuffer.append("Number of cycles performed: " + (this.m_Cycles - 1) + "\n");
        stringBuffer.append("Total number of frequent sequences: " + this.calcFreqSequencesTotal() + "\n\n");
        stringBuffer.append("Frequent Sequences Details (filtered):\n\n");
        for (int i = 0; i < this.m_AllSequentialPatterns.size(); ++i) {
            stringBuffer.append("- " + (i + 1) + "-sequences\n\n");
            FastVector fastVector = (FastVector)this.m_AllSequentialPatterns.elementAt(i);
            stringBuffer.append(Sequence.setOfSequencesToString(fastVector, this.m_OriginalDataSet, this.m_FilterAttrVector) + "\n");
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5504 $");
    }

    public static void main(String[] stringArray) {
        GeneralizedSequentialPatterns.runAssociator(new GeneralizedSequentialPatterns(), stringArray);
    }
}

