/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.Range;
import weka.core.Utils;
import weka.datagenerators.DataGenerator;

public abstract class ClusterGenerator
extends DataGenerator {
    private static final long serialVersionUID = 6131722618472046365L;
    protected int m_NumAttributes;
    protected boolean m_ClassFlag = false;
    protected Range m_booleanCols;
    protected Range m_nominalCols;

    public ClusterGenerator() {
        this.setNumAttributes(this.defaultNumAttributes());
    }

    public Enumeration listOptions() {
        Vector vector = this.enumToVector(super.listOptions());
        vector.addElement(new Option("\tThe number of attributes (default " + this.defaultNumAttributes() + ").", "a", 1, "-a <num>"));
        vector.addElement(new Option("\tClass Flag, if set, the cluster is listed in extra attribute.", "c", 0, "-c"));
        vector.addElement(new Option("\tThe indices for boolean attributes.", "b", 1, "-b <range>"));
        vector.addElement(new Option("\tThe indices for nominal attributes.", "m", 1, "-m <range>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('a', stringArray);
        if (string.length() != 0) {
            this.setNumAttributes(Integer.parseInt(string));
        } else {
            this.setNumAttributes(this.defaultNumAttributes());
        }
        this.setClassFlag(Utils.getFlag('c', stringArray));
        string = Utils.getOption('b', stringArray);
        this.setBooleanIndices(string);
        this.m_booleanCols.setUpper(this.getNumAttributes());
        string = Utils.getOption('m', stringArray);
        this.setNominalIndices(string);
        this.m_nominalCols.setUpper(this.getNumAttributes());
        string = this.checkIndices();
        if (string.length() > 0) {
            throw new IllegalArgumentException(string);
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-a");
        vector.add("" + this.getNumAttributes());
        if (this.getClassFlag()) {
            vector.add("-c");
        }
        if (!this.getBooleanCols().toString().equalsIgnoreCase("empty")) {
            vector.add("-b");
            vector.add("" + this.getBooleanCols());
        }
        if (!this.getNominalCols().toString().equalsIgnoreCase("empty")) {
            vector.add("-m");
            vector.add("" + this.getNominalCols());
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected int defaultNumAttributes() {
        return 10;
    }

    public void setNumAttributes(int n) {
        this.m_NumAttributes = n;
        this.getBooleanCols().setUpper(this.getNumAttributes());
        this.getNominalCols().setUpper(this.getNumAttributes());
    }

    public int getNumAttributes() {
        return this.m_NumAttributes;
    }

    public String numAttributesTipText() {
        return "The number of attributes the generated data will contain.";
    }

    public void setClassFlag(boolean bl) {
        this.m_ClassFlag = bl;
    }

    public boolean getClassFlag() {
        return this.m_ClassFlag;
    }

    public String classFlagTipText() {
        return "If set to TRUE, lists the cluster as an extra attribute.";
    }

    public void setBooleanIndices(String string) {
        this.m_booleanCols.setRanges(string);
    }

    public void setBooleanCols(Range range) {
        this.m_booleanCols.setRanges(range.getRanges());
    }

    public Range getBooleanCols() {
        if (this.m_booleanCols == null) {
            this.m_booleanCols = new Range();
        }
        return this.m_booleanCols;
    }

    public String booleanColsTipText() {
        return "The range of attributes that are generated as boolean ones.";
    }

    public void setNominalIndices(String string) {
        this.m_nominalCols.setRanges(string);
    }

    public void setNominalCols(Range range) {
        this.m_nominalCols.setRanges(range.getRanges());
    }

    public Range getNominalCols() {
        if (this.m_nominalCols == null) {
            this.m_nominalCols = new Range();
        }
        return this.m_nominalCols;
    }

    public String nominalColsTipText() {
        return "The range of attributes to generate as nominal ones.";
    }

    protected String checkIndices() {
        for (int i = 1; i < this.getNumAttributes() + 1; ++i) {
            this.m_booleanCols.isInRange(i);
            if (!this.m_booleanCols.isInRange(i) || !this.m_nominalCols.isInRange(i)) continue;
            return "Error in attribute type: Attribute " + i + " is set boolean and nominal.";
        }
        return "";
    }
}

