/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallSplitter;

public class MedianDistanceFromArbitraryPoint
extends BallSplitter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 5617378551363700558L;
    protected int m_RandSeed = 17;
    protected Random m_Rand;

    public MedianDistanceFromArbitraryPoint() {
    }

    public MedianDistanceFromArbitraryPoint(int[] nArray, Instances instances, EuclideanDistance euclideanDistance) {
        super(nArray, instances, euclideanDistance);
    }

    public String globalInfo() {
        return "Class that splits a BallNode of a ball tree using Uhlmann's described method.\n\nFor information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Jeffrey K. Uhlmann");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Satisfying general proximity/similarity queries with metric trees");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Information Processing Letters");
        technicalInformation.setValue(TechnicalInformation.Field.MONTH, "November");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1991");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "4");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "40");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "175-179");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.MASTERSTHESIS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Ashraf Masood Kibriya");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Fast Algorithms for Nearest Neighbour Search");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2007");
        technicalInformation2.setValue(TechnicalInformation.Field.SCHOOL, "Department of Computer Science, School of Computing and Mathematical Sciences, University of Waikato");
        technicalInformation2.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, New Zealand");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe seed value for the random number generator.\n\t(default: 17)", "S", 1, "-S <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('S', stringArray);
        if (string.length() > 0) {
            this.setRandomSeed(Integer.parseInt(string));
        } else {
            this.setRandomSeed(17);
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-S");
        vector.add("" + this.getRandomSeed());
        return vector.toArray(new String[vector.size()]);
    }

    public void setRandomSeed(int n) {
        this.m_RandSeed = n;
    }

    public int getRandomSeed() {
        return this.m_RandSeed;
    }

    public String randomSeedTipText() {
        return "The seed value for the random number generator.";
    }

    public void splitNode(BallNode ballNode, int n) throws Exception {
        this.correctlyInitialized();
        this.m_Rand = new Random(this.m_RandSeed);
        int n2 = ballNode.m_Start + this.m_Rand.nextInt(ballNode.m_NumInstances);
        Instance instance = (Instance)this.m_Instances.instance(this.m_Instlist[n2]).copy();
        double[] dArray = new double[ballNode.m_NumInstances - 1];
        int n3 = ballNode.m_Start;
        int n4 = 0;
        while (n3 < ballNode.m_End) {
            Instance instance2 = this.m_Instances.instance(this.m_Instlist[n3]);
            dArray[n4] = this.m_DistanceFunction.distance(instance, instance2, Double.POSITIVE_INFINITY);
            ++n3;
            ++n4;
        }
        n3 = this.select(dArray, this.m_Instlist, 0, dArray.length - 1, ballNode.m_Start, (ballNode.m_End - ballNode.m_Start) / 2 + 1) + ballNode.m_Start;
        Instance instance3 = BallNode.calcCentroidPivot(ballNode.m_Start, n3, this.m_Instlist, this.m_Instances);
        ballNode.m_Left = new BallNode(ballNode.m_Start, n3, n + 1, instance3, BallNode.calcRadius(ballNode.m_Start, n3, this.m_Instlist, this.m_Instances, instance3, this.m_DistanceFunction));
        instance3 = BallNode.calcCentroidPivot(n3 + 1, ballNode.m_End, this.m_Instlist, this.m_Instances);
        ballNode.m_Right = new BallNode(n3 + 1, ballNode.m_End, n + 2, instance3, BallNode.calcRadius(n3 + 1, ballNode.m_End, this.m_Instlist, this.m_Instances, instance3, this.m_DistanceFunction));
    }

    protected int partition(double[] dArray, int[] nArray, int n, int n2, int n3) {
        double d = dArray[(n + n2) / 2];
        while (n < n2) {
            while (dArray[n] < d && n < n2) {
                ++n;
            }
            while (dArray[n2] > d && n < n2) {
                --n2;
            }
            if (n >= n2) continue;
            int n4 = nArray[n3 + n];
            nArray[n3 + n] = nArray[n3 + n2];
            nArray[n3 + n2] = n4;
            ++n;
            --n2;
        }
        if (n == n2 && dArray[n2] > d) {
            --n2;
        }
        return n2;
    }

    protected int select(double[] dArray, int[] nArray, int n, int n2, int n3, int n4) {
        if (n == n2) {
            return n;
        }
        int n5 = this.partition(dArray, nArray, n, n2, n3);
        if (n5 - n + 1 >= n4) {
            return this.select(dArray, nArray, n, n5, n3, n4);
        }
        return this.select(dArray, nArray, n5 + 1, n2, n3, n4 - (n5 - n + 1));
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

