/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class ExponentialFormat
extends DecimalFormat
implements RevisionHandler {
    private static final long serialVersionUID = -5298981701073897741L;
    protected DecimalFormat nf;
    protected boolean sign;
    protected int digits;
    protected int exp;
    protected boolean trailing = true;

    public ExponentialFormat() {
        this(5);
    }

    public ExponentialFormat(int n) {
        this(n, false);
    }

    public ExponentialFormat(int n, boolean bl) {
        this(n, 2, true, bl);
    }

    public ExponentialFormat(int n, int n2, boolean bl, boolean bl2) {
        this.digits = n;
        this.exp = n2;
        this.sign = bl;
        this.trailing = bl2;
        this.nf = new DecimalFormat(this.pattern());
        this.nf.setPositivePrefix("+");
        this.nf.setNegativePrefix("-");
    }

    public int width() {
        if (!this.trailing) {
            throw new RuntimeException("flexible width");
        }
        if (this.sign) {
            return 1 + this.digits + 2 + this.exp;
        }
        return this.digits + 2 + this.exp;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2 = new StringBuffer(this.nf.format(d));
        if (this.sign) {
            if (stringBuffer2.charAt(0) == '+') {
                stringBuffer2.setCharAt(0, ' ');
            }
        } else if (stringBuffer2.charAt(0) == '-') {
            stringBuffer2.setCharAt(0, '*');
        } else {
            stringBuffer2.deleteCharAt(0);
        }
        return stringBuffer.append(stringBuffer2);
    }

    private String pattern() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0.");
        for (n = 0; n < this.digits - 1; ++n) {
            if (this.trailing) {
                stringBuffer.append('0');
                continue;
            }
            stringBuffer.append('#');
        }
        stringBuffer.append('E');
        for (n = 0; n < this.exp; ++n) {
            stringBuffer.append('0');
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

