/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.part;

import java.io.Serializable;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.rules.part.C45PruneableDecList;
import weka.classifiers.rules.part.ClassifierDecList;
import weka.classifiers.rules.part.PruneableDecList;
import weka.classifiers.trees.j48.ModelSelection;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;

public class MakeDecList
implements Serializable {
    private Vector theRules;
    private double CF = 0.25;
    private int minNumObj;
    private ModelSelection toSelectModeL;
    private int numSetS = 3;
    private boolean reducedErrorPruning = false;
    private boolean unpruned = false;
    private int m_seed = 1;

    public MakeDecList(ModelSelection modelSelection, int n) {
        this.toSelectModeL = modelSelection;
        this.reducedErrorPruning = false;
        this.unpruned = true;
        this.minNumObj = n;
    }

    public MakeDecList(ModelSelection modelSelection, double d, int n) {
        this.toSelectModeL = modelSelection;
        this.CF = d;
        this.reducedErrorPruning = false;
        this.unpruned = false;
        this.minNumObj = n;
    }

    public MakeDecList(ModelSelection modelSelection, int n, int n2, int n3) {
        this.toSelectModeL = modelSelection;
        this.numSetS = n;
        this.reducedErrorPruning = true;
        this.unpruned = false;
        this.minNumObj = n2;
        this.m_seed = n3;
    }

    public void buildClassifier(Instances instances) throws Exception {
        Instances instances2;
        Instances instances3;
        Object object;
        int n = 0;
        if (instances.classAttribute().isNumeric()) {
            throw new UnsupportedClassTypeException("Class is numeric!");
        }
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException("Cannot handle string attributes!");
        }
        this.theRules = new Vector();
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numInstances() == 0) {
            throw new Exception("No training instances/Only instances with missing class!");
        }
        if (this.reducedErrorPruning && !this.unpruned) {
            object = new Random(this.m_seed);
            instances.randomize((Random)object);
            instances.stratify(this.numSetS);
            instances3 = instances.trainCV(this.numSetS, this.numSetS - 1, (Random)object);
            instances2 = instances.testCV(this.numSetS, this.numSetS - 1);
        } else {
            instances3 = instances;
            instances2 = null;
        }
        while (Utils.gr(instances3.numInstances(), 0.0)) {
            double d;
            Instance instance;
            ClassifierDecList classifierDecList;
            if (this.unpruned) {
                classifierDecList = new ClassifierDecList(this.toSelectModeL, this.minNumObj);
                classifierDecList.buildRule(instances3);
            } else if (this.reducedErrorPruning) {
                classifierDecList = new PruneableDecList(this.toSelectModeL, this.minNumObj);
                ((PruneableDecList)classifierDecList).buildRule(instances3, instances2);
            } else {
                classifierDecList = new C45PruneableDecList(this.toSelectModeL, this.CF, this.minNumObj);
                ((C45PruneableDecList)classifierDecList).buildRule(instances3);
            }
            ++n;
            Instances instances4 = new Instances(instances3, instances3.numInstances());
            object = instances3.enumerateInstances();
            while (object.hasMoreElements()) {
                instance = (Instance)object.nextElement();
                d = classifierDecList.weight(instance);
                if (!Utils.sm(d, 1.0)) continue;
                instance.setWeight(instance.weight() * (1.0 - d));
                instances4.add(instance);
            }
            instances4.compactify();
            instances3 = instances4;
            if (this.reducedErrorPruning && !this.unpruned) {
                Instances instances5 = new Instances(instances2, instances2.numInstances());
                object = instances2.enumerateInstances();
                while (object.hasMoreElements()) {
                    instance = (Instance)object.nextElement();
                    d = classifierDecList.weight(instance);
                    if (!Utils.sm(d, 1.0)) continue;
                    instance.setWeight(instance.weight() * (1.0 - d));
                    instances5.add(instance);
                }
                instances5.compactify();
                instances2 = instances5;
            }
            this.theRules.addElement(classifierDecList);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.theRules.size(); ++i) {
            stringBuffer.append((ClassifierDecList)this.theRules.elementAt(i) + "\n");
        }
        stringBuffer.append("Number of Rules  : \t" + this.theRules.size() + "\n");
        return stringBuffer.toString();
    }

    public double classifyInstance(Instance instance) throws Exception {
        double d = -1.0;
        int n = 0;
        double[] dArray = this.distributionForInstance(instance);
        for (int i = 0; i < dArray.length; ++i) {
            if (!Utils.gr(dArray[i], d)) continue;
            n = i;
            d = dArray[i];
        }
        return n;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = null;
        double d = 1.0;
        double[] dArray2 = new double[instance.numClasses()];
        int n = 0;
        while (Utils.gr(d, 0.0)) {
            double d2 = ((ClassifierDecList)this.theRules.elementAt(n)).weight(instance);
            if (Utils.gr(d2, 0.0)) {
                dArray = ((ClassifierDecList)this.theRules.elementAt(n)).distributionForInstance(instance);
                for (int i = 0; i < dArray2.length; ++i) {
                    int n2 = i;
                    dArray2[n2] = dArray2[n2] + d * dArray[i];
                }
                d *= 1.0 - d2;
            }
            ++n;
        }
        return dArray2;
    }

    public int numRules() {
        return this.theRules.size();
    }
}

