% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.all.quantiles.mesh3D.plot.r
\name{sym.all.quantiles.mesh3D.plot}
\alias{sym.all.quantiles.mesh3D.plot}
\title{sym.all.quantiles.mesh3D.plot}
\usage{
sym.all.quantiles.mesh3D.plot(
  quantiles.sym,
  concept.names,
  var.names,
  Title,
  axes.x.label,
  axes.y.label,
  label.name
)
}
\arguments{
\item{quantiles.sym}{A quantile matrix}

\item{concept.names}{Concept Names}

\item{var.names}{Variables to plot}

\item{Title}{Plot title}

\item{axes.x.label}{Label of axis X}

\item{axes.y.label}{Label of axis Y}

\item{label.name}{Concept Variable}
}
\value{
3D Mesh Plot
}
\description{
sym.all.quantiles.mesh3D.plot
}
\examples{
\dontrun{
 data("hardwoodBrito")
 Hardwood.histogram<-hardwoodBrito
 Hardwood.cols<-colnames(Hardwood.histogram)
 Hardwood.names<-row.names(Hardwood.histogram)
 M<-length(Hardwood.cols)
 N<-length(Hardwood.names)
 BIN.Matrix<-matrix(rep(3,N*M),nrow = N)
 pca.hist<-sym.histogram.pca(Hardwood.histogram,BIN.Matrix)
 Hardwood.quantiles.PCA<-quantiles.RSDA(pca.hist$sym.hist.matrix.PCA,3)
 label.name<-"Hard Wood"
 Title<-"First Principal Plane"
 axes.x.label<- "First Principal Component (84.83\%)"
 axes.y.label<- "Second Principal Component (9.70\%)"
 concept.names<-c("ACER")
 var.names<-c("PC.1","PC.2")
 concept.names<-row.names(Hardwood.quantiles.PCA)
 sym.all.quantiles.mesh3D.plot(Hardwood.quantiles.PCA,
                           concept.names,
                           var.names,
                           Title,
                           axes.x.label,
                           axes.y.label,
                           label.name)
}
}
\author{
Jorge Arce Garro
}
