% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ChaudhuriChristofides}
\alias{ChaudhuriChristofides}
\title{Chaudhuri-Christofides model}
\usage{
ChaudhuriChristofides(z,mu,sigma,pi,type=c("total","mean"),cl,N=NULL,pij=NULL)
}
\arguments{
\item{z}{vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{mu}{vector with the means of the scramble variables}

\item{sigma}{vector with the standard deviations of the scramble variables}

\item{pi}{vector of the first-order inclusion probabilities}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence level}

\item{N}{size of the population. By default it is NULL}

\item{pij}{matrix of the second-order inclusion probabilities. By default it is NULL}
}
\value{
Point and confidence estimates of the sensitive characteristics using the Chaudhuri-Christofides model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence interval through the Chaudhuri-Christofides model.
The function can also return the transformed variable.
The Chaudhuri-Christofides model can be seen in Chaudhuri and Christofides (2013, page 97).
}
\details{
The randomized response given by the person \eqn{i} is \eqn{z_i=y_iS_1+S_2} where \eqn{S_1,S_2} are scramble variables, whose mean \eqn{\mu} and
standard deviation \eqn{\sigma} are known.
}
\examples{
N=417
data(ChaudhuriChristofidesData)
dat=with(ChaudhuriChristofidesData,data.frame(z,Pi))
mu=c(6,6)
sigma=sqrt(c(10,10))
cl=0.95
data(ChaudhuriChristofidesDatapij)
ChaudhuriChristofides(dat$z,mu,sigma,dat$Pi,"mean",cl,pij=ChaudhuriChristofidesDatapij)
}
\references{
Chaudhuri, A., and Christofides, T.C. (2013)
\emph{Indirect Questioning in Sample Surveys.}
Springer-Verlag Berlin Heidelberg.
}
\seealso{
\code{\link{ChaudhuriChristofidesData}}

\code{\link{ChaudhuriChristofidesDatapij}}

\code{\link{ResamplingVariance}}
}
\keyword{ChaudhuriChristofides}
\keyword{Confidence_interval}
\keyword{Estimation}
\keyword{Quantitative}
\keyword{Randomized_response}
\keyword{Transformed_variable}
\keyword{Variance}

