/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class PolygonFiller {
    int BLACK = -16777216;
    int WHITE = -1;
    int edges;
    int activeEdges;
    int[] x;
    int[] y;
    int n;
    double[] ex;
    int[] ey1;
    int[] ey2;
    double[] eslope;
    int[] sedge;
    int[] aedge;

    public PolygonFiller() {
    }

    public PolygonFiller(int[] nArray, int[] nArray2, int n) {
        this.setPolygon(nArray, nArray2, n);
    }

    public void setPolygon(int[] nArray, int[] nArray2, int n) {
        this.x = nArray;
        this.y = nArray2;
        this.n = n;
    }

    void allocateArrays(int n) {
        if (this.ex == null || n > this.ex.length) {
            this.ex = new double[n];
            this.ey1 = new int[n];
            this.ey2 = new int[n];
            this.sedge = new int[n];
            this.aedge = new int[n];
            this.eslope = new double[n];
        }
    }

    void buildEdgeTable(int[] nArray, int[] nArray2, int n) {
        int n2;
        this.edges = 0;
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = n2 == n - 1 ? 0 : n2 + 1;
            int n4 = nArray2[n2];
            int n5 = nArray2[n3];
            int n6 = nArray[n2];
            int n7 = nArray[n3];
            if (n4 == n5) continue;
            if (n4 > n5) {
                int n8 = n4;
                n4 = n5;
                n5 = n8;
                n8 = n6;
                n6 = n7;
                n7 = n8;
            }
            double d = (double)(n7 - n6) / (double)(n5 - n4);
            this.ex[this.edges] = (double)n6 + d / 2.0;
            this.ey1[this.edges] = n4;
            this.ey2[this.edges] = n5;
            this.eslope[this.edges] = d;
            ++this.edges;
        }
        for (n2 = 0; n2 < this.edges; ++n2) {
            this.sedge[n2] = n2;
        }
        this.activeEdges = 0;
    }

    void addToSortedTable(int n) {
        int n2;
        for (n2 = 0; n2 < this.edges && this.ey1[this.edges] > this.ey1[this.sedge[n2]]; ++n2) {
        }
        for (int i = this.edges - 1; i >= n2; --i) {
            this.sedge[i + 1] = this.sedge[i];
        }
        this.sedge[n2] = this.edges;
    }

    public void fill(ImageProcessor imageProcessor, Rectangle rectangle) {
        imageProcessor.fill(this.getMask(rectangle.width, rectangle.height));
    }

    public ImageProcessor getMask(int n, int n2) {
        this.allocateArrays(this.n);
        this.buildEdgeTable(this.x, this.y, this.n);
        ByteProcessor byteProcessor = new ByteProcessor(n, n2);
        byte[] byArray = (byte[])((ImageProcessor)byteProcessor).getPixels();
        for (int i = 0; i < n2; ++i) {
            this.removeInactiveEdges(i);
            this.activateEdges(i);
            int n3 = i * n;
            for (int j = 0; j < this.activeEdges; j += 2) {
                int n4;
                int n5 = (int)(this.ex[this.aedge[j]] + 0.5);
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > n) {
                    n5 = n;
                }
                if ((n4 = (int)(this.ex[this.aedge[j + 1]] + 0.5)) < 0) {
                    n4 = 0;
                }
                if (n4 > n) {
                    n4 = n;
                }
                for (int k = n5; k < n4; ++k) {
                    byArray[n3 + k] = -1;
                }
            }
            this.updateXCoordinates();
        }
        return byteProcessor;
    }

    void updateXCoordinates() {
        double d = -1.7976931348623157E308;
        boolean bl = true;
        for (int i = 0; i < this.activeEdges; ++i) {
            double d2;
            int n = this.aedge[i];
            this.ex[n] = d2 = this.ex[n] + this.eslope[n];
            if (d2 < d) {
                bl = false;
            }
            d = d2;
        }
        if (!bl) {
            this.sortActiveEdges();
        }
    }

    void sortActiveEdges() {
        for (int i = 0; i < this.activeEdges; ++i) {
            int n = i;
            for (int j = i; j < this.activeEdges; ++j) {
                if (!(this.ex[this.aedge[j]] < this.ex[this.aedge[n]])) continue;
                n = j;
            }
            int n2 = this.aedge[n];
            this.aedge[n] = this.aedge[i];
            this.aedge[i] = n2;
        }
    }

    void removeInactiveEdges(int n) {
        int n2 = 0;
        while (n2 < this.activeEdges) {
            int n3 = this.aedge[n2];
            if (n < this.ey1[n3] || n >= this.ey2[n3]) {
                for (int i = n2; i < this.activeEdges - 1; ++i) {
                    this.aedge[i] = this.aedge[i + 1];
                }
                --this.activeEdges;
                continue;
            }
            ++n2;
        }
    }

    void activateEdges(int n) {
        for (int i = 0; i < this.edges; ++i) {
            int n2;
            int n3 = this.sedge[i];
            if (n != this.ey1[n3]) continue;
            for (n2 = 0; n2 < this.activeEdges && this.ex[n3] > this.ex[this.aedge[n2]]; ++n2) {
            }
            for (int j = this.activeEdges - 1; j >= n2; --j) {
                this.aedge[j + 1] = this.aedge[j];
            }
            this.aedge[n2] = n3;
            ++this.activeEdges;
        }
    }

    void printEdges() {
        for (int i = 0; i < this.edges; ++i) {
            int n = this.sedge[i];
            IJ.log(i + "\t" + this.ex[n] + "  " + this.ey1[n] + "  " + this.ey2[n] + "  " + IJ.d2s(this.eslope[n], 2));
        }
    }

    void printActiveEdges() {
        for (int i = 0; i < this.activeEdges; ++i) {
            int n = this.aedge[i];
            IJ.log(i + "\t" + this.ex[n] + "  " + this.ey1[n] + "  " + this.ey2[n]);
        }
    }
}

