/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.macro.Interpreter;
import java.util.Hashtable;
import java.util.Locale;

public class Macro {
    public static final String MACRO_CANCELED = "Macro canceled";
    private static Hashtable table = new Hashtable();
    static boolean abort;

    public static boolean open(String string) {
        if (string == null || string.equals("")) {
            Opener opener = new Opener();
            return true;
        }
        Opener opener = new Opener();
        ImagePlus imagePlus = opener.openImage(string);
        if (imagePlus == null) {
            return false;
        }
        imagePlus.show();
        return true;
    }

    public static boolean saveAs(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return false;
        }
        FileSaver fileSaver = new FileSaver(imagePlus);
        if (string == null || string.equals("")) {
            return fileSaver.saveAsTiff();
        }
        if (imagePlus.getStackSize() > 1) {
            return fileSaver.saveAsTiffStack(string);
        }
        return fileSaver.saveAsTiff(string);
    }

    public static String getName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getDir(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        if (n > 0) {
            return string.substring(0, n + 1);
        }
        return "";
    }

    public static void abort() {
        abort = true;
        if (Thread.currentThread().getName().endsWith("Macro$")) {
            table.remove(Thread.currentThread());
            throw new RuntimeException(MACRO_CANCELED);
        }
    }

    public static String getOptions() {
        if (Thread.currentThread().getName().startsWith("Run$_")) {
            Object v = table.get(Thread.currentThread());
            return v == null ? null : v + " ";
        }
        return null;
    }

    public static void setOptions(String string) {
        if (string == null || string.equals("")) {
            table.remove(Thread.currentThread());
        } else {
            table.put(Thread.currentThread(), string);
        }
    }

    public static void setOptions(Thread thread, String string) {
        if (null == thread) {
            throw new RuntimeException("Need a non-null thread instance");
        }
        if (null == string) {
            table.remove(thread);
        } else {
            table.put(thread, string);
        }
    }

    public static String getValue(String string, String string2, String string3) {
        string2 = Macro.trimKey(string2);
        string2 = string2 + '=';
        int n = -1;
        do {
            ++n;
            if ((n = string.indexOf(string2, n)) >= 0) continue;
            return string3;
        } while (n != 0 && Character.isLetter(string.charAt(n - 1)));
        if ((string = string.substring(n + string2.length(), string.length())).charAt(0) == '\'') {
            n = string.indexOf("'", 1);
            if (n < 0) {
                return string3;
            }
            return string.substring(1, n);
        }
        if (string.charAt(0) == '[') {
            n = string.indexOf("]", 1);
            if (n < 0) {
                return string3;
            }
            return string.substring(1, n);
        }
        n = string.indexOf(" ");
        if (n < 0) {
            return string3;
        }
        return string.substring(0, n);
    }

    public static String trimKey(String string) {
        int n = string.indexOf(" ");
        if (n > -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(":")) > -1) {
            string = string.substring(0, n);
        }
        string = string.toLowerCase(Locale.US);
        return string;
    }

    public static void setLocalVariable(String string, String string2) {
        Interpreter interpreter = Interpreter.getInstance();
        if (interpreter == null) {
            return;
        }
        interpreter.setLocalVariable(string, string2);
    }
}

