/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class FloatStatistics
extends ImageStatistics {
    public FloatStatistics(ImageProcessor imageProcessor) {
        this(imageProcessor, 27, null);
    }

    public FloatStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        double d;
        double d2;
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        this.setup(imageProcessor, calibration);
        double d3 = imageProcessor.getMinThreshold();
        if ((n & 0x100) == 0 || d3 == -808080.0) {
            d2 = -3.4028234663852886E38;
            d = 3.4028234663852886E38;
        } else {
            d2 = d3;
            d = imageProcessor.getMaxThreshold();
        }
        this.getStatistics(imageProcessor, d2, d);
        if ((n & 8) != 0) {
            this.getMode();
        }
        if ((n & 0x800) != 0 || (n & 0x2000) != 0) {
            this.fitEllipse(imageProcessor);
        } else if ((n & 0x20) != 0) {
            this.getCentroid(imageProcessor, d2, d);
        }
        if ((n & 0x60040) != 0) {
            this.calculateMoments(imageProcessor, d2, d);
        }
        if ((n & 0x10000) != 0) {
            if (Double.isInfinite(this.binSize) || Double.isNaN(this.binSize)) {
                this.median = 0.0;
            } else {
                this.calculateMedian(this.histogram, 0, this.histogram.length - 1, null);
                this.median = this.histMin + this.median * this.binSize;
                if (this.binSize != 1.0) {
                    this.median += this.binSize / 2.0;
                }
            }
        }
        if ((n & 0x80000) != 0) {
            this.calculateAreaFraction(imageProcessor);
        }
    }

    void getStatistics(ImageProcessor imageProcessor, double d, double d2) {
        double d3;
        int n;
        int n2;
        int n3;
        float[] fArray = (float[])imageProcessor.getPixels();
        this.nBins = imageProcessor.getHistogramSize();
        this.histMin = imageProcessor.getHistogramMin();
        this.histMax = imageProcessor.getHistogramMax();
        this.histogram = new int[this.nBins];
        double d4 = 0.0;
        double d5 = 0.0;
        byte[] byArray = imageProcessor.getMaskArray();
        double d6 = Double.MAX_VALUE;
        double d7 = -1.7976931348623157E308;
        double d8 = Double.MAX_VALUE;
        double d9 = -1.7976931348623157E308;
        int n4 = this.ry;
        int n5 = 0;
        while (n4 < this.ry + this.rh) {
            n3 = n4 * this.width + this.rx;
            n2 = n5 * this.rw;
            for (n = this.rx; n < this.rx + this.rw; ++n) {
                if ((byArray == null || byArray[n2++] != 0) && (d3 = (double)fArray[n3]) >= d && d3 <= d2) {
                    if (d3 < d6) {
                        d6 = d3;
                    }
                    if (d3 > d7) {
                        d7 = d3;
                    }
                }
                ++n3;
            }
            ++n4;
            ++n5;
        }
        this.min = d6;
        this.max = d7;
        if (this.histMin == 0.0 && this.histMax == 0.0) {
            this.histMin = this.min;
            this.histMax = this.max;
        } else {
            if (this.min < this.histMin) {
                this.min = this.histMin;
            }
            if (this.max > this.histMax) {
                this.max = this.histMax;
            }
        }
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double d10 = (double)this.nBins / (this.histMax - this.histMin);
        this.pixelCount = 0;
        n2 = this.ry;
        n = 0;
        while (n2 < this.ry + this.rh) {
            int n6 = n2 * this.width + this.rx;
            int n7 = n * this.rw;
            for (int i = this.rx; i < this.rx + this.rw; ++i) {
                if ((byArray == null || byArray[n7++] != 0) && (d3 = (double)fArray[n6]) >= d && d3 <= d2 && d3 >= this.histMin && d3 <= this.histMax) {
                    ++this.pixelCount;
                    d4 += d3;
                    d5 += d3 * d3;
                    n3 = (int)(d10 * (d3 - this.histMin));
                    if (n3 >= this.nBins) {
                        n3 = this.nBins - 1;
                    }
                    int n8 = n3;
                    this.histogram[n8] = this.histogram[n8] + 1;
                }
                ++n6;
            }
            ++n2;
            ++n;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.umean = this.mean = d4 / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, d4, d5);
    }

    void getMode() {
        this.maxCount = 0;
        for (int i = 0; i < this.nBins; ++i) {
            int n = this.histogram[i];
            if (n <= this.maxCount) continue;
            this.maxCount = n;
            this.mode = i;
        }
        this.dmode = this.histMin + (double)this.mode * this.binSize;
        if (this.binSize != 1.0) {
            this.dmode += this.binSize / 2.0;
        }
    }

    void calculateMoments(ImageProcessor imageProcessor, double d, double d2) {
        float[] fArray = (float[])imageProcessor.getPixels();
        byte[] byArray = imageProcessor.getMaskArray();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n = this.ry;
        int n2 = 0;
        while (n < this.ry + this.rh) {
            int n3 = n * this.width + this.rx;
            int n4 = n2 * this.rw;
            for (int i = this.rx; i < this.rx + this.rw; ++i) {
                double d9;
                if ((byArray == null || byArray[n4++] != 0) && (d9 = (double)fArray[n3] + Double.MIN_VALUE) >= d && d9 <= d2) {
                    double d10 = d9 * d9;
                    d3 += d9;
                    d4 += d10;
                    d5 += d9 * d10;
                    d6 += d10 * d10;
                    d7 += (double)i * d9;
                    d8 += (double)n * d9;
                }
                ++n3;
            }
            ++n;
            ++n2;
        }
        double d11 = this.mean * this.mean;
        double d12 = d4 / (double)this.pixelCount - d11;
        double d13 = Math.sqrt(d12);
        this.skewness = ((d5 - 3.0 * this.mean * d4) / (double)this.pixelCount + 2.0 * this.mean * d11) / (d12 * d13);
        this.kurtosis = ((d6 - 4.0 * this.mean * d5 + 6.0 * d11 * d4) / (double)this.pixelCount - 3.0 * d11 * d11) / (d12 * d12) - 3.0;
        this.xCenterOfMass = d7 / d3 + 0.5;
        this.yCenterOfMass = d8 / d3 + 0.5;
        if (this.cal != null) {
            this.xCenterOfMass = this.cal.getX(this.xCenterOfMass);
            this.yCenterOfMass = this.cal.getY(this.yCenterOfMass, this.height);
        }
    }

    void getCentroid(ImageProcessor imageProcessor, double d, double d2) {
        float[] fArray = (float[])imageProcessor.getPixels();
        byte[] byArray = imageProcessor.getMaskArray();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = this.ry;
        int n2 = 0;
        while (n < this.ry + this.rh) {
            int n3 = n * this.width + this.rx;
            int n4 = n2 * this.rw;
            for (int i = this.rx; i < this.rx + this.rw; ++i) {
                double d6;
                if ((byArray == null || byArray[n4++] != 0) && (d6 = (double)fArray[n3]) >= d && d6 <= d2) {
                    d3 += 1.0;
                    d4 += (double)i;
                    d5 += (double)n;
                }
                ++n3;
            }
            ++n;
            ++n2;
        }
        this.xCentroid = d4 / d3 + 0.5;
        this.yCentroid = d5 / d3 + 0.5;
        if (this.cal != null) {
            this.xCentroid = this.cal.getX(this.xCentroid);
            this.yCentroid = this.cal.getY(this.yCentroid, this.height);
        }
    }

    void calculateAreaFraction(ImageProcessor imageProcessor) {
        int n = 0;
        int n2 = 0;
        float f = (float)imageProcessor.getMinThreshold();
        float f2 = (float)imageProcessor.getMaxThreshold();
        float[] fArray = (float[])imageProcessor.getPixels();
        boolean bl = (double)f == -808080.0;
        byte[] byArray = imageProcessor.getMaskArray();
        int n3 = this.ry;
        int n4 = 0;
        while (n3 < this.ry + this.rh) {
            int n5 = n3 * this.width + this.rx;
            int n6 = n4 * this.rw;
            for (int i = this.rx; i < this.rx + this.rw; ++i) {
                if (byArray == null || byArray[n6++] != 0) {
                    float f3 = fArray[n5];
                    ++n2;
                    if (bl) {
                        if (f3 != 0.0f) {
                            ++n;
                        }
                    } else if (f3 >= f && f3 <= f2) {
                        ++n;
                    }
                }
                ++n5;
            }
            ++n3;
            ++n4;
        }
        this.areaFraction = (double)n * 100.0 / (double)n2;
    }
}

