/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImageListener;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.FreehandRoi;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.PlotWindow;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.StackWindow;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.frame.ContrastAdjuster;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import ij.process.ShortProcessor;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.util.Properties;
import java.util.Vector;

public class ImagePlus
implements ImageObserver,
Measurements {
    public static final int GRAY8 = 0;
    public static final int GRAY16 = 1;
    public static final int GRAY32 = 2;
    public static final int COLOR_256 = 3;
    public static final int COLOR_RGB = 4;
    public boolean changes;
    protected Image img;
    protected ImageProcessor ip;
    protected ImageWindow win;
    protected Roi roi;
    protected int currentSlice;
    protected static final int OPENED = 0;
    protected static final int CLOSED = 1;
    protected static final int UPDATED = 2;
    protected boolean compositeImage;
    protected int width;
    protected int height;
    protected boolean locked = false;
    protected int nChannels = 1;
    protected int nSlices = 1;
    protected int nFrames = 1;
    private ImageJ ij = IJ.getInstance();
    private String title;
    private String url;
    private FileInfo fileInfo;
    private int imageType = 0;
    private ImageStack stack;
    private static int currentID = -1;
    private int ID;
    private static Component comp;
    private boolean imageLoaded;
    private int imageUpdateY;
    private int imageUpdateW;
    private Properties properties;
    private long startTime;
    private Calibration calibration;
    private static Calibration globalCalibration;
    private boolean activated;
    private boolean ignoreFlush;
    private boolean errorLoadingImage;
    private static ImagePlus clipboard;
    private static Vector listeners;
    private boolean openAsHyperStack;
    private int[] position = new int[]{1, 1, 1};
    private boolean noUpdateMode;
    private ImageCanvas flatteningCanvas;
    private Overlay overlay;
    private boolean hideOverlay;
    private static int default16bitDisplayRange;
    long waitStart;
    private int[] pvalue = new int[4];
    private int savex;
    private int savey;

    public ImagePlus() {
        this.ID = --currentID;
        this.title = "null";
    }

    public ImagePlus(String string, Image image) {
        this.title = string;
        this.ID = --currentID;
        if (image != null) {
            this.setImage(image);
        }
    }

    public ImagePlus(String string, ImageProcessor imageProcessor) {
        this.setProcessor(string, imageProcessor);
        this.ID = --currentID;
    }

    public ImagePlus(String string) {
        Opener opener = new Opener();
        ImagePlus imagePlus = null;
        boolean bl = string.indexOf("://") > 0;
        imagePlus = bl ? opener.openURL(string) : opener.openImage(string);
        if (imagePlus != null) {
            if (imagePlus.getStackSize() > 1) {
                this.setStack(imagePlus.getTitle(), imagePlus.getStack());
            } else {
                this.setProcessor(imagePlus.getTitle(), imagePlus.getProcessor());
            }
            this.setCalibration(imagePlus.getCalibration());
            this.properties = imagePlus.getProperties();
            this.setFileInfo(imagePlus.getOriginalFileInfo());
            this.setDimensions(imagePlus.getNChannels(), imagePlus.getNSlices(), imagePlus.getNFrames());
            if (bl) {
                this.url = string;
            }
            this.ID = --currentID;
        }
    }

    public ImagePlus(String string, ImageStack imageStack) {
        this.setStack(string, imageStack);
        this.ID = --currentID;
    }

    public synchronized boolean lock() {
        if (this.locked) {
            IJ.beep();
            IJ.showStatus("\"" + this.title + "\" is locked");
            return false;
        }
        this.locked = true;
        if (IJ.debugMode) {
            IJ.log(this.title + ": lock");
        }
        return true;
    }

    public synchronized boolean lockSilently() {
        if (this.locked) {
            return false;
        }
        this.locked = true;
        if (IJ.debugMode) {
            IJ.log(this.title + ": lock silently");
        }
        return true;
    }

    public synchronized void unlock() {
        this.locked = false;
        if (IJ.debugMode) {
            IJ.log(this.title + ": unlock");
        }
    }

    private void waitForImage(Image image) {
        if (comp == null && (comp = IJ.getInstance()) == null) {
            comp = new Canvas();
        }
        this.imageLoaded = false;
        if (!comp.prepareImage(image, this)) {
            this.waitStart = System.currentTimeMillis();
            while (!this.imageLoaded && !this.errorLoadingImage) {
                IJ.wait(30);
                if (this.imageUpdateW <= 1) continue;
                double d = (double)this.imageUpdateY / (double)this.imageUpdateW;
                if (!(d < 1.0) && (d = 1.0 - (d - 1.0)) < 0.0) {
                    d = 0.9;
                }
                this.showProgress(d);
            }
            this.showProgress(1.0);
        }
    }

    private void showProgress(double d) {
        if (System.currentTimeMillis() - this.waitStart > 500L) {
            IJ.showProgress(d);
        }
    }

    public void draw() {
        if (this.win != null) {
            this.win.getCanvas().repaint();
        }
    }

    public void draw(int n, int n2, int n3, int n4) {
        if (this.win != null) {
            ImageCanvas imageCanvas = this.win.getCanvas();
            double d = imageCanvas.getMagnification();
            n = imageCanvas.screenX(n);
            n2 = imageCanvas.screenY(n2);
            n3 = (int)((double)n3 * d);
            n4 = (int)((double)n4 * d);
            imageCanvas.repaint(n, n2, n3, n4);
            if (listeners.size() > 0 && this.roi != null && this.roi.getPasteMode() != -1) {
                this.notifyListeners(2);
            }
        }
    }

    public void updateAndDraw() {
        if (this.ip != null) {
            if (this.win != null) {
                this.win.getCanvas().setImageUpdated();
                if (listeners.size() > 0) {
                    this.notifyListeners(2);
                }
            }
            this.draw();
        }
    }

    public void updateChannelAndDraw() {
        this.updateAndDraw();
    }

    public ImageProcessor getChannelProcessor() {
        return this.getProcessor();
    }

    public LUT[] getLuts() {
        return null;
    }

    public void repaintWindow() {
        if (this.win != null) {
            this.draw();
            this.win.repaint();
        }
    }

    public void updateAndRepaintWindow() {
        if (this.win != null) {
            this.updateAndDraw();
            this.win.repaint();
        }
    }

    public void updateImage() {
        if (this.ip != null) {
            this.img = this.ip.createImage();
        }
    }

    public void hide() {
        if (this.win == null) {
            Interpreter.removeBatchModeImage(this);
            return;
        }
        boolean bl = this.lockSilently();
        this.changes = false;
        this.win.close();
        this.win = null;
        if (bl) {
            this.unlock();
        }
    }

    public void close() {
        ImageWindow imageWindow = this.getWindow();
        if (imageWindow != null) {
            imageWindow.close();
        } else {
            if (WindowManager.getCurrentImage() == this) {
                WindowManager.setTempCurrentImage(null);
            }
            this.killRoi();
            Interpreter.removeBatchModeImage(this);
        }
    }

    public void show() {
        this.show("");
    }

    public void show(String string) {
        if (this.win != null) {
            return;
        }
        if (IJ.isMacro() && this.ij == null || Interpreter.isBatchMode()) {
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null) {
                imagePlus.saveRoi();
            }
            WindowManager.setTempCurrentImage(this);
            Interpreter.addBatchModeImage(this);
            return;
        }
        if (Prefs.useInvertingLut && this.getBitDepth() == 8 && this.ip != null && !this.ip.isInvertedLut() && !this.ip.isColorLut()) {
            this.invertLookupTable();
        }
        this.img = this.getImage();
        if (this.img != null && this.width >= 0 && this.height >= 0) {
            this.activated = false;
            int n = this.getStackSize();
            this.win = n > 1 ? new StackWindow(this) : new ImageWindow(this);
            if (this.roi != null) {
                this.roi.setImage(this);
            }
            if (this.overlay != null && this.getCanvas() != null) {
                this.getCanvas().setOverlay(this.overlay);
            }
            this.draw();
            IJ.showStatus(string);
            if (IJ.isMacro()) {
                long l = System.currentTimeMillis();
                while (!this.activated) {
                    IJ.wait(5);
                    if (System.currentTimeMillis() - l <= 2000L) continue;
                    WindowManager.setTempCurrentImage(this);
                    break;
                }
            }
            if (this.imageType == 1 && default16bitDisplayRange != 0) {
                this.resetDisplayRange();
                this.updateAndDraw();
            }
            this.notifyListeners(0);
        }
    }

    void invertLookupTable() {
        int n = this.getStackSize();
        this.ip.invertLut();
        if (n == 1) {
            this.ip.invert();
        } else {
            ImageStack imageStack = this.getStack();
            for (int i = 1; i <= n; ++i) {
                imageStack.getProcessor(i).invert();
            }
            imageStack.setColorModel(this.ip.getColorModel());
        }
    }

    public void setActivated() {
        this.activated = true;
    }

    public Image getImage() {
        if (this.img == null && this.ip != null) {
            this.img = this.ip.createImage();
        }
        return this.img;
    }

    public BufferedImage getBufferedImage() {
        if (this.isComposite()) {
            return new ColorProcessor(this.getImage()).getBufferedImage();
        }
        return this.ip.getBufferedImage();
    }

    public int getID() {
        return this.ID;
    }

    public void setImage(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (bufferedImage.getType() == 11) {
                this.setProcessor(null, new ShortProcessor(bufferedImage));
                return;
            }
            if (bufferedImage.getType() == 10) {
                this.setProcessor(null, new ByteProcessor(bufferedImage));
                return;
            }
        }
        this.roi = null;
        this.errorLoadingImage = false;
        this.waitForImage(image);
        if (this.errorLoadingImage) {
            throw new IllegalStateException("Error loading image");
        }
        this.img = image;
        int n = image.getWidth(this.ij);
        int n2 = image.getHeight(this.ij);
        boolean bl = n != this.width || n2 != this.height;
        this.width = n;
        this.height = n2;
        this.ip = null;
        this.stack = null;
        LookUpTable lookUpTable = new LookUpTable(image);
        int n3 = lookUpTable.getMapSize() > 0 ? (lookUpTable.isGrayscale() ? 0 : 3) : 4;
        this.setType(n3);
        this.setupProcessor();
        this.img = this.ip.createImage();
        if (this.win != null) {
            if (bl) {
                this.win = new ImageWindow(this);
            } else {
                this.repaintWindow();
            }
        }
    }

    public void setProcessor(ImageProcessor imageProcessor) {
        this.setProcessor(null, imageProcessor);
    }

    public void setProcessor(String string, ImageProcessor imageProcessor) {
        if (imageProcessor == null || imageProcessor.getPixels() == null) {
            throw new IllegalArgumentException("ip null or ip.getPixels() null");
        }
        int n = this.getStackSize();
        if (n > 1 && (imageProcessor.getWidth() != this.width || imageProcessor.getHeight() != this.height)) {
            throw new IllegalArgumentException("ip wrong size");
        }
        if (n <= 1) {
            this.stack = null;
            this.setCurrentSlice(1);
        }
        this.setProcessor2(string, imageProcessor, null);
    }

    void setProcessor2(String string, ImageProcessor imageProcessor, ImageStack imageStack) {
        boolean bl;
        if (string != null) {
            this.setTitle(string);
        }
        this.ip = imageProcessor;
        if (this.ij != null) {
            imageProcessor.setProgressBar(this.ij.getProgressBar());
        }
        int n = 1;
        if (this.stack != null && this.currentSlice > (n = this.stack.getSize())) {
            this.setCurrentSlice(n);
        }
        this.img = null;
        boolean bl2 = bl = this.width > 0 && this.height > 0 && (this.width != imageProcessor.getWidth() || this.height != imageProcessor.getHeight());
        if (bl) {
            this.roi = null;
        }
        int n2 = imageProcessor instanceof ByteProcessor ? 0 : (imageProcessor instanceof ColorProcessor ? 4 : (imageProcessor instanceof ShortProcessor ? 1 : 2));
        if (this.width == 0) {
            this.imageType = n2;
        } else {
            this.setType(n2);
        }
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        if (this.win != null) {
            if (bl && n == 1) {
                this.win.updateImage(this);
            } else if (imageStack == null) {
                this.repaintWindow();
            }
            this.draw();
        }
    }

    public void setStack(ImageStack imageStack) {
        this.setStack(null, imageStack);
    }

    public void setStack(String string, ImageStack imageStack) {
        boolean bl;
        int n;
        Object[] objectArray;
        int n2 = imageStack.getSize();
        if (n2 == 0) {
            throw new IllegalArgumentException("Stack is empty");
        }
        if (!imageStack.isVirtual() && ((objectArray = imageStack.getImageArray()) == null || objectArray.length > 0 && objectArray[0] == null)) {
            throw new IllegalArgumentException("Stack pixel array null");
        }
        boolean bl2 = false;
        if (this.win != null && this.win instanceof StackWindow) {
            n = ((StackWindow)this.win).getNScrollbars();
            if (n > 0 && n2 == 1) {
                bl2 = true;
            } else if (n == 0 && n2 > 1) {
                bl2 = true;
            }
        }
        if (this.currentSlice < 1) {
            this.setCurrentSlice(1);
        }
        int n3 = n = this.currentSlice > n2 ? 1 : 0;
        if (n != 0) {
            this.setCurrentSlice(n2);
        }
        ImageProcessor imageProcessor = imageStack.getProcessor(this.currentSlice);
        boolean bl3 = this.width > 0 && this.height > 0 && (this.width != imageProcessor.getWidth() || this.height != imageProcessor.getHeight());
        this.stack = imageStack;
        this.setProcessor2(string, imageProcessor, imageStack);
        if (this.win == null) {
            if (n != 0) {
                this.setSlice(this.currentSlice);
            }
            return;
        }
        boolean bl4 = bl = this.isDisplayedHyperStack() && !((StackWindow)this.win).validDimensions();
        if (n2 > 1 && !(this.win instanceof StackWindow)) {
            if (this.isDisplayedHyperStack()) {
                this.setOpenAsHyperStack(true);
            }
            this.win = new StackWindow(this, this.getCanvas());
            this.setPosition(1, 1, 1);
        } else if (n2 > 1 && bl) {
            if (this.isDisplayedHyperStack()) {
                this.setOpenAsHyperStack(true);
            }
            this.win = new StackWindow(this);
            this.setPosition(1, 1, 1);
        } else if (bl3 || bl2) {
            this.win.updateImage(this);
        } else {
            this.repaintWindow();
        }
        if (n != 0) {
            this.setSlice(this.currentSlice);
        }
    }

    public void setStack(ImageStack imageStack, int n, int n2, int n3) {
        if (n * n2 * n3 != imageStack.getSize()) {
            throw new IllegalArgumentException("channels*slices*frames!=stackSize");
        }
        this.nChannels = n;
        this.nSlices = n2;
        this.nFrames = n3;
        if (this.isComposite()) {
            ((CompositeImage)this).setChannelsUpdated();
        }
        this.setStack(null, imageStack);
    }

    public void setFileInfo(FileInfo fileInfo) {
        if (fileInfo != null) {
            fileInfo.pixels = null;
        }
        this.fileInfo = fileInfo;
    }

    public ImageWindow getWindow() {
        return this.win;
    }

    public boolean isVisible() {
        return this.win != null && this.win.isVisible();
    }

    public void setWindow(ImageWindow imageWindow) {
        this.win = imageWindow;
        if (this.roi != null) {
            this.roi.setImage(this);
        }
    }

    public ImageCanvas getCanvas() {
        return this.win != null ? this.win.getCanvas() : this.flatteningCanvas;
    }

    public void setColor(Color color) {
        if (this.ip != null) {
            this.ip.setColor(color);
        }
    }

    void setupProcessor() {
        if (this.imageType == 4) {
            if (this.ip == null || this.ip instanceof ByteProcessor) {
                this.ip = new ColorProcessor(this.getImage());
            }
        } else if (this.ip == null || this.ip instanceof ColorProcessor) {
            this.ip = new ByteProcessor(this.getImage());
        }
        if (this.roi != null && this.roi.isArea()) {
            this.ip.setRoi(this.roi.getBounds());
        } else {
            this.ip.resetRoi();
        }
    }

    public boolean isProcessor() {
        return this.ip != null;
    }

    public ImageProcessor getProcessor() {
        Recorder recorder;
        Calibration calibration;
        if (this.ip == null && this.img == null) {
            return null;
        }
        this.setupProcessor();
        if (!this.compositeImage) {
            this.ip.setLineWidth(Line.getWidth());
        }
        if (this.ij != null) {
            this.ip.setProgressBar(this.ij.getProgressBar());
        }
        if ((calibration = this.getCalibration()).calibrated()) {
            this.ip.setCalibrationTable(calibration.getCTable());
        } else {
            this.ip.setCalibrationTable(null);
        }
        if (Recorder.record && (recorder = Recorder.getInstance()) != null) {
            recorder.imageUpdated(this);
        }
        return this.ip;
    }

    public void trimProcessor() {
        ImageProcessor imageProcessor = this.ip;
        if (!this.locked && imageProcessor != null) {
            if (IJ.debugMode) {
                IJ.log(this.title + ": trimProcessor");
            }
            imageProcessor.setSnapshotPixels(null);
        }
    }

    public void killProcessor() {
    }

    public ImageProcessor getMask() {
        if (this.roi == null) {
            if (this.ip != null) {
                this.ip.resetRoi();
            }
            return null;
        }
        ImageProcessor imageProcessor = this.roi.getMask();
        if (imageProcessor == null) {
            return null;
        }
        if (this.ip != null) {
            this.ip.setMask(imageProcessor);
            this.ip.setRoi(this.roi.getBounds());
        }
        return imageProcessor;
    }

    public ImageStatistics getStatistics() {
        return this.getStatistics(27);
    }

    public ImageStatistics getStatistics(int n) {
        return this.getStatistics(n, 256, 0.0, 0.0);
    }

    public ImageStatistics getStatistics(int n, int n2) {
        return this.getStatistics(n, n2, 0.0, 0.0);
    }

    public ImageStatistics getStatistics(int n, int n2, double d, double d2) {
        this.setupProcessor();
        if (this.roi != null && this.roi.isArea()) {
            this.ip.setRoi(this.roi);
        } else {
            this.ip.resetRoi();
        }
        this.ip.setHistogramSize(n2);
        Calibration calibration = this.getCalibration();
        if (this.getType() == 1 && (d != 0.0 || d2 != 0.0)) {
            d = calibration.getRawValue(d);
            d2 = calibration.getRawValue(d2);
        }
        this.ip.setHistogramRange(d, d2);
        ImageStatistics imageStatistics = ImageStatistics.getStatistics(this.ip, n, calibration);
        this.ip.setHistogramSize(256);
        this.ip.setHistogramRange(0.0, 0.0);
        return imageStatistics;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public String getShortTitle() {
        String string = this.getTitle();
        int n = string.indexOf(32);
        if (n > -1) {
            string = string.substring(0, n);
        }
        if ((n = string.lastIndexOf(46)) > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public void setTitle(String string) {
        if (string == null) {
            return;
        }
        if (this.win != null) {
            if (this.ij != null) {
                Menus.updateWindowMenuItem(this.title, string);
            }
            String string2 = this.stack != null && this.stack.isVirtual() ? " (V)" : "";
            String string3 = this.getGlobalCalibration() != null ? " (G)" : "";
            String string4 = "";
            double d = this.win.getCanvas().getMagnification();
            if (d != 1.0) {
                double d2 = d * 100.0;
                int n = d2 > 100.0 || d2 == (double)((int)d2) ? 0 : 1;
                string4 = " (" + IJ.d2s(d2, n) + "%)";
            }
            this.win.setTitle(string + string2 + string3 + string4);
        }
        this.title = string;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStackSize() {
        if (this.stack == null) {
            return 1;
        }
        int n = this.stack.getSize();
        if (n <= 0) {
            n = 1;
        }
        return n;
    }

    public int getImageStackSize() {
        if (this.stack == null) {
            return 1;
        }
        int n = this.stack.getSize();
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public void setDimensions(int n, int n2, int n3) {
        if (n * n2 * n3 != this.getImageStackSize() && this.ip != null) {
            n = 1;
            n2 = this.getImageStackSize();
            n3 = 1;
            if (this.isDisplayedHyperStack()) {
                this.setOpenAsHyperStack(false);
                new StackWindow(this);
                this.setSlice(1);
            }
        }
        boolean bl = this.isDisplayedHyperStack() && (this.nChannels != n || this.nSlices != n2 || this.nFrames != n3);
        this.nChannels = n;
        this.nSlices = n2;
        this.nFrames = n3;
        if (bl) {
            if (n2 != this.getImageStackSize()) {
                this.setOpenAsHyperStack(true);
            }
            this.ip = null;
            this.img = null;
            this.setPositionWithoutUpdate(this.getChannel(), this.getSlice(), this.getFrame());
            if (this.isComposite()) {
                ((CompositeImage)this).reset();
            }
            new StackWindow(this);
            this.setPosition(this.getChannel(), this.getSlice(), this.getFrame());
        }
    }

    public boolean isHyperStack() {
        return this.isDisplayedHyperStack() || this.openAsHyperStack && this.getNDimensions() > 3;
    }

    public int getNDimensions() {
        int n = 2;
        int[] nArray = this.getDimensions();
        if (nArray[2] > 1) {
            ++n;
        }
        if (nArray[3] > 1) {
            ++n;
        }
        if (nArray[4] > 1) {
            ++n;
        }
        return n;
    }

    public boolean isDisplayedHyperStack() {
        return this.win != null && this.win instanceof StackWindow && ((StackWindow)this.win).isHyperStack();
    }

    public int getNChannels() {
        this.verifyDimensions();
        return this.nChannels;
    }

    public int getNSlices() {
        this.verifyDimensions();
        return this.nSlices;
    }

    public int getNFrames() {
        this.verifyDimensions();
        return this.nFrames;
    }

    public int[] getDimensions() {
        this.verifyDimensions();
        int[] nArray = new int[]{this.width, this.height, this.nChannels, this.nSlices, this.nFrames};
        return nArray;
    }

    void verifyDimensions() {
        int n = this.getImageStackSize();
        if (this.nSlices == 1) {
            if (this.nChannels > 1 && this.nFrames == 1) {
                this.nChannels = n;
            } else if (this.nFrames > 1 && this.nChannels == 1) {
                this.nFrames = n;
            }
        }
        if (this.nChannels * this.nSlices * this.nFrames != n) {
            this.nSlices = n;
            this.nChannels = 1;
            this.nFrames = 1;
        }
    }

    public int getType() {
        return this.imageType;
    }

    public int getBitDepth() {
        int n = 0;
        switch (this.imageType) {
            case 0: 
            case 3: {
                n = 8;
                break;
            }
            case 1: {
                n = 16;
                break;
            }
            case 2: {
                n = 32;
                break;
            }
            case 4: {
                n = 24;
            }
        }
        return n;
    }

    public int getBytesPerPixel() {
        switch (this.imageType) {
            case 1: {
                return 2;
            }
            case 2: 
            case 4: {
                return 4;
            }
        }
        return 1;
    }

    protected void setType(int n) {
        if (n < 0 || n > 4) {
            return;
        }
        int n2 = this.imageType;
        this.imageType = n;
        if (this.imageType != n2) {
            if (this.win != null) {
                Menus.updateMenus();
            }
            this.getLocalCalibration().setImage(this);
        }
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (object == null) {
            this.properties.remove(string);
        } else {
            this.properties.put(string, object);
        }
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public LookUpTable createLut() {
        ImageProcessor imageProcessor = this.getProcessor();
        if (imageProcessor != null) {
            return new LookUpTable(imageProcessor.getColorModel());
        }
        return new LookUpTable(LookUpTable.createGrayscaleColorModel(false));
    }

    public boolean isInvertedLut() {
        if (this.ip == null) {
            if (this.img == null) {
                return false;
            }
            this.setupProcessor();
        }
        return this.ip.isInvertedLut();
    }

    public int[] getPixel(int n, int n2) {
        this.pvalue[3] = 0;
        this.pvalue[2] = 0;
        this.pvalue[1] = 0;
        this.pvalue[0] = 0;
        switch (this.imageType) {
            case 0: 
            case 3: {
                Object object;
                int n3;
                if (this.ip != null) {
                    n3 = this.ip.getPixel(n, n2);
                } else {
                    if (this.img == null) {
                        return this.pvalue;
                    }
                    object = new PixelGrabber(this.img, n, n2, 1, 1, false);
                    try {
                        ((PixelGrabber)object).grabPixels();
                    }
                    catch (InterruptedException interruptedException) {
                        return this.pvalue;
                    }
                    byte[] byArray = (byte[])((PixelGrabber)object).getPixels();
                    int n4 = n3 = byArray != null ? byArray[0] & 0xFF : 0;
                }
                if (this.imageType != 3) {
                    this.pvalue[0] = n3;
                    return this.pvalue;
                }
                this.pvalue[3] = n3;
            }
            case 4: {
                Object object;
                Object object2 = 0;
                if (this.imageType == 4 && this.ip != null) {
                    object2 = this.ip.getPixel(n, n2);
                } else {
                    object = new int[1];
                    if (this.img == null) {
                        return this.pvalue;
                    }
                    PixelGrabber pixelGrabber = new PixelGrabber(this.img, n, n2, 1, 1, (int[])object, 0, this.width);
                    try {
                        pixelGrabber.grabPixels();
                    }
                    catch (InterruptedException interruptedException) {
                        return this.pvalue;
                    }
                    object2 = object[0];
                }
                int n5 = (object2 & 0xFF0000) >> 16;
                int n6 = (object2 & 0xFF00) >> 8;
                int n7 = object2 & 0xFF;
                this.pvalue[0] = n5;
                this.pvalue[1] = n6;
                this.pvalue[2] = n7;
                break;
            }
            case 1: 
            case 2: {
                if (this.ip == null) break;
                this.pvalue[0] = this.ip.getPixel(n, n2);
            }
        }
        return this.pvalue;
    }

    public ImageStack createEmptyStack() {
        ColorModel colorModel = this.ip != null ? this.ip.getColorModel() : this.createLut().getColorModel();
        return new ImageStack(this.width, this.height, colorModel);
    }

    public ImageStack getStack() {
        ImageStack imageStack;
        if (this.stack == null) {
            imageStack = this.createEmptyStack();
            ImageProcessor imageProcessor = this.getProcessor();
            if (imageProcessor == null) {
                return imageStack;
            }
            String string = (String)this.getProperty("Info");
            String string2 = string != null ? this.getTitle() + "\n" + string : null;
            imageStack.addSlice(string2, imageProcessor);
            imageStack.update(imageProcessor);
        } else {
            imageStack = this.stack;
            if (this.ip != null) {
                Calibration calibration = this.getCalibration();
                if (calibration.calibrated()) {
                    this.ip.setCalibrationTable(calibration.getCTable());
                } else {
                    this.ip.setCalibrationTable(null);
                }
            }
            imageStack.update(this.ip);
        }
        if (this.roi != null) {
            imageStack.setRoi(this.roi.getBounds());
        } else {
            imageStack.setRoi(null);
        }
        return imageStack;
    }

    public ImageStack getImageStack() {
        if (this.stack == null) {
            return this.getStack();
        }
        this.stack.update(this.ip);
        return this.stack;
    }

    public int getCurrentSlice() {
        if (this.currentSlice < 1) {
            this.setCurrentSlice(1);
        }
        if (this.currentSlice > this.getStackSize()) {
            this.setCurrentSlice(this.getStackSize());
        }
        return this.currentSlice;
    }

    final void setCurrentSlice(int n) {
        this.currentSlice = n;
        int n2 = this.getStackSize();
        if (this.nChannels == n2) {
            this.updatePosition(this.currentSlice, 1, 1);
        }
        if (this.nSlices == n2) {
            this.updatePosition(1, this.currentSlice, 1);
        }
        if (this.nFrames == n2) {
            this.updatePosition(1, 1, this.currentSlice);
        }
    }

    public int getChannel() {
        return this.position[0];
    }

    public int getSlice() {
        return this.position[1];
    }

    public int getFrame() {
        return this.position[2];
    }

    public void killStack() {
        this.stack = null;
        this.trimProcessor();
    }

    public void setPosition(int n, int n2, int n3) {
        this.verifyDimensions();
        if (n < 1) {
            n = 1;
        }
        if (n > this.nChannels) {
            n = this.nChannels;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > this.nSlices) {
            n2 = this.nSlices;
        }
        if (n3 < 1) {
            n3 = 1;
        }
        if (n3 > this.nFrames) {
            n3 = this.nFrames;
        }
        if (this.isDisplayedHyperStack()) {
            ((StackWindow)this.win).setPosition(n, n2, n3);
        } else {
            this.setSlice((n3 - 1) * this.nChannels * this.nSlices + (n2 - 1) * this.nChannels + n);
            this.updatePosition(n, n2, n3);
        }
    }

    public void setPositionWithoutUpdate(int n, int n2, int n3) {
        this.noUpdateMode = true;
        this.setPosition(n, n2, n3);
        this.noUpdateMode = false;
    }

    public int getStackIndex(int n, int n2, int n3) {
        if (n < 1) {
            n = 1;
        }
        if (n > this.nChannels) {
            n = this.nChannels;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > this.nSlices) {
            n2 = this.nSlices;
        }
        if (n3 < 1) {
            n3 = 1;
        }
        if (n3 > this.nFrames) {
            n3 = this.nFrames;
        }
        return (n3 - 1) * this.nChannels * this.nSlices + (n2 - 1) * this.nChannels + n;
    }

    public void resetStack() {
        if (this.currentSlice == 1 && this.stack != null && this.stack.getSize() > 0) {
            ColorModel colorModel = this.ip.getColorModel();
            double d = this.ip.getMin();
            double d2 = this.ip.getMax();
            this.ip = this.stack.getProcessor(1);
            this.ip.setColorModel(colorModel);
            this.ip.setMinAndMax(d, d2);
        }
    }

    public void setPosition(int n) {
        int[] nArray = this.convertIndexToPosition(n);
        this.setPosition(nArray[0], nArray[1], nArray[2]);
    }

    public int[] convertIndexToPosition(int n) {
        if (n < 1 || n > this.getStackSize()) {
            throw new IllegalArgumentException("n out of range: " + n);
        }
        int[] nArray = new int[3];
        int[] nArray2 = this.getDimensions();
        nArray[0] = (n - 1) % nArray2[2] + 1;
        nArray[1] = (n - 1) / nArray2[2] % nArray2[3] + 1;
        nArray[2] = (n - 1) / (nArray2[2] * nArray2[3]) % nArray2[4] + 1;
        return nArray;
    }

    public synchronized void setSlice(int n) {
        if (this.stack == null || n == this.currentSlice && this.ip != null) {
            this.updateAndRepaintWindow();
            return;
        }
        if (n >= 1 && n <= this.stack.getSize()) {
            Roi roi = this.getRoi();
            if (roi != null) {
                roi.endPaste();
            }
            if (this.isProcessor()) {
                this.stack.setPixels(this.ip.getPixels(), this.currentSlice);
            }
            this.ip = this.getProcessor();
            this.setCurrentSlice(n);
            Object object = this.stack.getPixels(this.currentSlice);
            if (this.ip != null && object != null) {
                this.ip.setSnapshotPixels(null);
                this.ip.setPixels(object);
            } else {
                this.ip = this.stack.getProcessor(n);
            }
            if (this.win != null && this.win instanceof StackWindow) {
                ((StackWindow)this.win).updateSliceSelector();
            }
            if (this.imageType == 4) {
                ContrastAdjuster.update();
            }
            if (!Interpreter.isBatchMode() && !this.noUpdateMode) {
                this.updateAndRepaintWindow();
            } else {
                this.img = null;
            }
        }
    }

    public void setSliceWithoutUpdate(int n) {
        this.noUpdateMode = true;
        this.setSlice(n);
        this.noUpdateMode = false;
    }

    public Roi getRoi() {
        return this.roi;
    }

    public void setRoi(Roi roi) {
        this.setRoi(roi, true);
    }

    public void setRoi(Roi roi, boolean bl) {
        if (roi == null) {
            this.killRoi();
            return;
        }
        if (roi.isVisible() && (roi = (Roi)roi.clone()) == null) {
            this.killRoi();
            return;
        }
        Rectangle rectangle = roi.getBounds();
        if (rectangle.width == 0 && rectangle.height == 0 && roi.getType() != 10 && roi.getType() != 5) {
            this.killRoi();
            return;
        }
        this.roi = roi;
        if (this.ip != null) {
            this.ip.setMask(null);
            if (this.roi.isArea()) {
                this.ip.setRoi(rectangle);
            } else {
                this.ip.resetRoi();
            }
        }
        this.roi.setImage(this);
        if (bl) {
            this.draw();
        }
    }

    public void setRoi(int n, int n2, int n3, int n4) {
        this.setRoi(new Rectangle(n, n2, n3, n4));
    }

    public void setRoi(Rectangle rectangle) {
        this.setRoi(new Roi(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
    }

    public void createNewRoi(int n, int n2) {
        this.killRoi();
        switch (Toolbar.getToolId()) {
            case 0: {
                this.roi = new Roi(n, n2, this, Toolbar.getRoundRectArcSize());
                break;
            }
            case 1: {
                this.roi = new OvalRoi(n, n2, this);
                break;
            }
            case 2: 
            case 5: 
            case 14: {
                this.roi = new PolygonRoi(n, n2, this);
                break;
            }
            case 3: 
            case 6: {
                this.roi = new FreehandRoi(n, n2, this);
                break;
            }
            case 4: {
                if ("arrow".equals(Toolbar.getToolName())) {
                    this.roi = new Arrow(n, n2, this);
                    break;
                }
                this.roi = new Line(n, n2, this);
                break;
            }
            case 9: {
                this.roi = new TextRoi(n, n2, this);
                break;
            }
            case 7: {
                this.roi = new PointRoi(n, n2, this);
                if (Prefs.pointAutoMeasure || Prefs.pointAutoNextSlice && !Prefs.pointAddToManager) {
                    IJ.run("Measure");
                }
                if (Prefs.pointAddToManager) {
                    IJ.run("Add to Manager ");
                    ImageCanvas imageCanvas = this.getCanvas();
                    if (imageCanvas != null && !imageCanvas.getShowAllROIs()) {
                        imageCanvas.setShowAllROIs(true);
                    }
                }
                if (!Prefs.pointAutoNextSlice || this.getStackSize() <= 1) break;
                IJ.run("Next Slice [>]");
                this.killRoi();
            }
        }
    }

    public void killRoi() {
        if (this.roi != null) {
            this.saveRoi();
            this.roi = null;
            if (this.ip != null) {
                this.ip.resetRoi();
            }
            this.draw();
        }
    }

    public void saveRoi() {
        if (this.roi != null) {
            this.roi.endPaste();
            Rectangle rectangle = this.roi.getBounds();
            if (rectangle.width > 0 && rectangle.height > 0) {
                Roi.previousRoi = (Roi)this.roi.clone();
                if (IJ.debugMode) {
                    IJ.log("saveRoi: " + this.roi);
                }
            }
        }
    }

    public void restoreRoi() {
        if (Roi.previousRoi != null) {
            Roi roi = Roi.previousRoi;
            Rectangle rectangle = roi.getBounds();
            if (rectangle.width <= this.width || rectangle.height <= this.height || this.isSmaller(roi)) {
                this.roi = (Roi)roi.clone();
                this.roi.setImage(this);
                if (rectangle.x >= this.width || rectangle.y >= this.height || rectangle.x + rectangle.width <= 0 || rectangle.y + rectangle.height <= 0) {
                    this.roi.setLocation((this.width - rectangle.width) / 2, (this.height - rectangle.height) / 2);
                } else if (rectangle.width == this.width && rectangle.height == this.height) {
                    this.roi.setLocation(0, 0);
                }
                this.draw();
            }
        }
    }

    boolean isSmaller(Roi roi) {
        ImageProcessor imageProcessor = roi.getMask();
        if (imageProcessor == null) {
            return false;
        }
        imageProcessor.setThreshold(255.0, 255.0, 2);
        ImageStatistics imageStatistics = ImageStatistics.getStatistics(imageProcessor, 258, null);
        return imageStatistics.area <= (double)(this.width * this.height);
    }

    public void revert() {
        boolean bl;
        if (this.getStackSize() > 1 && this.getStack().isVirtual()) {
            return;
        }
        FileInfo fileInfo = this.getOriginalFileInfo();
        boolean bl2 = bl = fileInfo != null && fileInfo.fileFormat != 0;
        if (!bl && this.url == null) {
            return;
        }
        if (this.ij != null && this.changes && bl && !Interpreter.isBatchMode() && !IJ.isMacro() && !IJ.altKeyDown() && !IJ.showMessageWithCancel("Revert?", "Revert to saved version of\n\"" + this.getTitle() + "\"?")) {
            return;
        }
        Roi roi = null;
        if (this.roi != null) {
            this.roi.endPaste();
            roi = (Roi)this.roi.clone();
        }
        if (this.getStackSize() > 1) {
            this.revertStack(fileInfo);
            return;
        }
        this.trimProcessor();
        if (bl && (this.url == null || fileInfo.directory != null && !fileInfo.directory.equals(""))) {
            new FileOpener(fileInfo).revertToSaved(this);
        } else if (this.url != null) {
            IJ.showStatus("Loading: " + this.url);
            Opener opener = new Opener();
            try {
                ImagePlus imagePlus = opener.openURL(this.url);
                if (imagePlus != null) {
                    this.setProcessor(null, imagePlus.getProcessor());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.getType() == 4 && this.getTitle().endsWith(".jpg")) {
                Opener.convertGrayJpegTo8Bits(this);
            }
        }
        if (Prefs.useInvertingLut && this.getBitDepth() == 8 && this.ip != null && !this.ip.isInvertedLut() && !this.ip.isColorLut()) {
            this.invertLookupTable();
        }
        if (this.getProperty("FHT") != null) {
            this.properties.remove("FHT");
            if (this.getTitle().startsWith("FFT of ")) {
                this.setTitle(this.getTitle().substring(7));
            }
        }
        ContrastAdjuster.update();
        if (roi != null) {
            this.setRoi(roi);
        }
        this.repaintWindow();
        IJ.showStatus("");
        this.changes = false;
        this.notifyListeners(2);
    }

    void revertStack(FileInfo fileInfo) {
        String string = null;
        String string2 = null;
        if (this.url != null && !this.url.equals("")) {
            string = this.url;
            string2 = this.url;
        } else if (fileInfo != null && fileInfo.directory != null && !fileInfo.directory.equals("")) {
            string = fileInfo.directory + fileInfo.fileName;
        } else if (fileInfo != null && fileInfo.url != null && !fileInfo.url.equals("")) {
            string = fileInfo.url;
            string2 = fileInfo.url;
        } else {
            return;
        }
        IJ.showStatus("Loading: " + string);
        ImagePlus imagePlus = IJ.openImage(string);
        if (imagePlus != null) {
            int n = imagePlus.getStackSize();
            int n2 = imagePlus.getNChannels();
            int n3 = imagePlus.getNSlices();
            int n4 = imagePlus.getNFrames();
            if (n3 == n || n4 == n || n2 == this.getNChannels() && n3 == this.getNSlices() && n4 == this.getNFrames()) {
                this.setCalibration(imagePlus.getCalibration());
                this.setStack(imagePlus.getStack(), n2, n3, n4);
            } else {
                ImageWindow imageWindow = this.getWindow();
                Point point = null;
                if (imageWindow != null) {
                    point = imageWindow.getLocation();
                }
                this.changes = false;
                this.close();
                FileInfo fileInfo2 = imagePlus.getOriginalFileInfo();
                if (fileInfo2 != null && (fileInfo2.url == null || fileInfo2.url.length() == 0)) {
                    fileInfo2.url = string2;
                    imagePlus.setFileInfo(fileInfo2);
                }
                ImageWindow.setNextLocation(point);
                imagePlus.show();
            }
        }
    }

    public FileInfo getFileInfo() {
        FileInfo fileInfo = new FileInfo();
        fileInfo.width = this.width;
        fileInfo.height = this.height;
        fileInfo.nImages = this.getStackSize();
        if (this.compositeImage) {
            fileInfo.nImages = this.getImageStackSize();
        }
        fileInfo.whiteIsZero = this.isInvertedLut();
        fileInfo.intelByteOrder = false;
        this.setupProcessor();
        fileInfo.pixels = fileInfo.nImages == 1 ? this.ip.getPixels() : this.stack.getImageArray();
        Calibration calibration = this.getCalibration();
        if (calibration.scaled()) {
            fileInfo.pixelWidth = calibration.pixelWidth;
            fileInfo.pixelHeight = calibration.pixelHeight;
            fileInfo.unit = calibration.getUnit();
        }
        if (fileInfo.nImages > 1) {
            fileInfo.pixelDepth = calibration.pixelDepth;
        }
        fileInfo.frameInterval = calibration.frameInterval;
        if (calibration.calibrated()) {
            fileInfo.calibrationFunction = calibration.getFunction();
            fileInfo.coefficients = calibration.getCoefficients();
            fileInfo.valueUnit = calibration.getValueUnit();
        }
        switch (this.imageType) {
            case 0: 
            case 3: {
                LookUpTable lookUpTable = this.createLut();
                fileInfo.fileType = this.imageType == 3 || !lookUpTable.isGrayscale() ? 5 : 0;
                fileInfo.lutSize = lookUpTable.getMapSize();
                fileInfo.reds = lookUpTable.getReds();
                fileInfo.greens = lookUpTable.getGreens();
                fileInfo.blues = lookUpTable.getBlues();
                break;
            }
            case 1: {
                if (this.compositeImage && fileInfo.nImages == 3) {
                    fileInfo.fileType = 12;
                    break;
                }
                fileInfo.fileType = 2;
                break;
            }
            case 2: {
                fileInfo.fileType = 4;
                break;
            }
            case 4: {
                fileInfo.fileType = 6;
                break;
            }
        }
        return fileInfo;
    }

    public FileInfo getOriginalFileInfo() {
        if (this.fileInfo == null & this.url != null) {
            this.fileInfo = new FileInfo();
            this.fileInfo.width = this.width;
            this.fileInfo.height = this.height;
            this.fileInfo.url = this.url;
            this.fileInfo.directory = null;
        }
        return this.fileInfo;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this.imageUpdateY = n3;
        this.imageUpdateW = n4;
        if ((n & 0x40) != 0) {
            this.errorLoadingImage = true;
            return false;
        }
        this.imageLoaded = (n & 0xB0) != 0;
        return !this.imageLoaded;
    }

    public synchronized void flush() {
        Object[] objectArray;
        this.notifyListeners(1);
        if (this.locked || this.ignoreFlush) {
            return;
        }
        this.ip = null;
        if (this.roi != null) {
            this.roi.setImage(null);
        }
        this.roi = null;
        if (this.stack != null && (objectArray = this.stack.getImageArray()) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = null;
            }
        }
        this.stack = null;
        this.img = null;
        this.win = null;
        if (this.roi != null) {
            this.roi.setImage(null);
        }
        this.roi = null;
        this.properties = null;
        this.calibration = null;
        this.overlay = null;
        this.flatteningCanvas = null;
    }

    public void setIgnoreFlush(boolean bl) {
        this.ignoreFlush = bl;
    }

    public ImagePlus createImagePlus() {
        ImagePlus imagePlus = new ImagePlus();
        imagePlus.setType(this.getType());
        imagePlus.setCalibration(this.getCalibration());
        return imagePlus;
    }

    public ImagePlus createHyperStack(String string, int n, int n2, int n3, int n4) {
        int n5 = n * n2 * n3;
        ImageStack imageStack = new ImageStack(this.width, this.height, n5);
        ImageProcessor imageProcessor = null;
        switch (n4) {
            case 8: {
                imageProcessor = new ByteProcessor(this.width, this.height);
                break;
            }
            case 16: {
                imageProcessor = new ShortProcessor(this.width, this.height);
                break;
            }
            case 24: {
                imageProcessor = new ColorProcessor(this.width, this.height);
                break;
            }
            case 32: {
                imageProcessor = new FloatProcessor(this.width, this.height);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid bit depth");
            }
        }
        imageStack.setPixels(imageProcessor.getPixels(), 1);
        ImagePlus imagePlus = new ImagePlus(string, imageStack);
        imageStack.setPixels(null, 1);
        imagePlus.setDimensions(n, n2, n3);
        imagePlus.setCalibration(this.getCalibration());
        imagePlus.setOpenAsHyperStack(true);
        return imagePlus;
    }

    public void copyScale(ImagePlus imagePlus) {
        if (imagePlus != null && globalCalibration == null) {
            this.setCalibration(imagePlus.getCalibration());
        }
    }

    public void startTiming() {
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Calibration getCalibration() {
        if (globalCalibration != null) {
            Calibration calibration = globalCalibration.copy();
            calibration.setImage(this);
            return calibration;
        }
        if (this.calibration == null) {
            this.calibration = new Calibration(this);
        }
        return this.calibration;
    }

    public void setCalibration(Calibration calibration) {
        if (calibration == null) {
            this.calibration = null;
        } else {
            this.calibration = calibration.copy();
            this.calibration.setImage(this);
        }
    }

    public void setGlobalCalibration(Calibration calibration) {
        globalCalibration = calibration == null ? null : calibration.copy();
    }

    public Calibration getGlobalCalibration() {
        return globalCalibration;
    }

    public Calibration getLocalCalibration() {
        if (this.calibration == null) {
            this.calibration = new Calibration(this);
        }
        return this.calibration;
    }

    public void mouseMoved(int n, int n2) {
        if (this.ij != null) {
            this.ij.showStatus(this.getLocationAsString(n, n2) + this.getValueAsString(n, n2));
        }
        this.savex = n;
        this.savey = n2;
    }

    public void updateStatusbarValue() {
        IJ.showStatus(this.getLocationAsString(this.savex, this.savey) + this.getValueAsString(this.savex, this.savey));
    }

    String getFFTLocation(int n, int n2, Calibration calibration) {
        double d = (double)this.width / 2.0;
        double d2 = Math.sqrt(((double)n - d) * ((double)n - d) + ((double)n2 - d) * ((double)n2 - d));
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        double d3 = Math.atan2((double)n2 - d, (double)n - d);
        if ((d3 = d3 * 180.0 / Math.PI) < 0.0) {
            d3 = 360.0 + d3;
        }
        String string = "r=";
        string = calibration.scaled() ? string + IJ.d2s((double)this.width / d2 * calibration.pixelWidth, 2) + " " + calibration.getUnit() + "/c (" + IJ.d2s(d2, 0) + ")" : string + IJ.d2s((double)this.width / d2, 2) + " p/c (" + IJ.d2s(d2, 0) + ")";
        string = string + ", theta= " + IJ.d2s(d3, 2) + '\u00b0';
        return string;
    }

    public String getLocationAsString(int n, int n2) {
        Calibration calibration = this.getCalibration();
        if (this.getProperty("FHT") != null) {
            return this.getFFTLocation(n, this.height - n2 - 1, calibration);
        }
        if (!IJ.altKeyDown()) {
            String string = " x=" + this.d2s(calibration.getX(n)) + ", y=" + this.d2s(calibration.getY(n2, this.height));
            if (this.getStackSize() > 1) {
                int n3 = this.isDisplayedHyperStack() ? this.getSlice() - 1 : this.getCurrentSlice() - 1;
                string = string + ", z=" + this.d2s(calibration.getZ(n3));
            }
            return string;
        }
        String string = " x=" + n + ", y=" + n2;
        if (this.getStackSize() > 1) {
            int n4 = this.isDisplayedHyperStack() ? this.getSlice() - 1 : this.getCurrentSlice() - 1;
            string = string + ", z=" + n4;
        }
        return string;
    }

    private String d2s(double d) {
        return d == (double)((int)d) ? Integer.toString((int)d) : IJ.d2s(d);
    }

    private String getValueAsString(int n, int n2) {
        if (this.win != null && this.win instanceof PlotWindow) {
            return "";
        }
        Calibration calibration = this.getCalibration();
        int[] nArray = this.getPixel(n, n2);
        int n3 = this.getType();
        switch (n3) {
            case 0: 
            case 1: 
            case 3: {
                double d;
                if (n3 == 3) {
                    if (calibration.getCValue(nArray[3]) == (double)nArray[3]) {
                        return ", index=" + nArray[3] + ", value=" + nArray[0] + "," + nArray[1] + "," + nArray[2];
                    }
                    nArray[0] = nArray[3];
                }
                if ((d = calibration.getCValue(nArray[0])) == (double)nArray[0]) {
                    return ", value=" + nArray[0];
                }
                return ", value=" + IJ.d2s(d) + " (" + nArray[0] + ")";
            }
            case 2: {
                return ", value=" + Float.intBitsToFloat(nArray[0]);
            }
            case 4: {
                return ", value=" + nArray[0] + "," + nArray[1] + "," + nArray[2];
            }
        }
        return "";
    }

    public void copy(boolean bl) {
        String string;
        Roi roi = this.getRoi();
        if (roi != null && !roi.isArea()) {
            IJ.error("Cut/Copy", "The Cut and Copy commands require\nan area selection, or no selection.");
            return;
        }
        boolean bl2 = Interpreter.isBatchMode();
        String string2 = string = bl ? "Cutt" : "Copy";
        if (!bl2) {
            IJ.showStatus(string + "ing...");
        }
        ImageProcessor imageProcessor = this.getProcessor();
        Roi roi2 = null;
        ImageProcessor imageProcessor2 = imageProcessor.crop();
        if (roi != null && roi.getType() != 0) {
            roi2 = (Roi)roi.clone();
            Rectangle rectangle = roi.getBounds();
            if (rectangle.x < 0 || rectangle.y < 0 || rectangle.x + rectangle.width > this.width || rectangle.y + rectangle.height > this.height) {
                roi2 = new ShapeRoi(roi2);
                ShapeRoi shapeRoi = new ShapeRoi(new Roi(0, 0, this.width, this.height));
                roi2 = shapeRoi.and((ShapeRoi)roi2);
            }
        }
        clipboard = new ImagePlus("Clipboard", imageProcessor2);
        if (roi2 != null) {
            clipboard.setRoi(roi2);
        }
        if (bl) {
            imageProcessor.snapshot();
            imageProcessor.setColor(Toolbar.getBackgroundColor());
            imageProcessor.fill();
            if (roi != null && roi.getType() != 0) {
                this.getMask();
                imageProcessor.reset(imageProcessor.getMask());
            }
            this.setColor(Toolbar.getForegroundColor());
            Undo.setup(1, this);
            this.updateAndDraw();
        }
        int n = 1;
        switch (clipboard.getType()) {
            case 1: {
                n = 2;
                break;
            }
            case 2: 
            case 4: {
                n = 4;
            }
        }
        if (!bl2) {
            string = bl ? "Cut" : "Copy";
            IJ.showStatus(string + ": " + clipboard.getWidth() * clipboard.getHeight() * n / 1024 + "k");
        }
    }

    public void paste() {
        if (clipboard == null) {
            return;
        }
        int n = clipboard.getType();
        int n2 = this.getType();
        int n3 = clipboard.getWidth();
        int n4 = clipboard.getHeight();
        Roi roi = clipboard.getRoi();
        Rectangle rectangle = null;
        Roi roi2 = this.getRoi();
        if (roi2 != null) {
            rectangle = roi2.getBounds();
        }
        if (n3 == this.width && n4 == this.height && (rectangle == null || n3 != rectangle.width || n4 != rectangle.height)) {
            this.setRoi(0, 0, this.width, this.height);
            roi2 = this.getRoi();
            rectangle = roi2.getBounds();
        }
        if (rectangle == null || rectangle != null && (n3 != rectangle.width || n4 != rectangle.height)) {
            ImageCanvas imageCanvas = null;
            if (this.win != null) {
                imageCanvas = this.win.getCanvas();
            }
            Rectangle rectangle2 = imageCanvas != null ? imageCanvas.getSrcRect() : new Rectangle(0, 0, this.width, this.height);
            int n5 = rectangle2.x + rectangle2.width / 2;
            int n6 = rectangle2.y + rectangle2.height / 2;
            if (roi != null && roi.getType() != 0) {
                roi.setImage(this);
                roi.setLocation(n5 - n3 / 2, n6 - n4 / 2);
                this.setRoi(roi);
            } else {
                this.setRoi(n5 - n3 / 2, n6 - n4 / 2, n3, n4);
            }
            roi2 = this.getRoi();
        }
        if (IJ.isMacro()) {
            int n7 = Roi.getCurrentPasteMode();
            boolean bl = roi2.getType() != 0;
            ImageProcessor imageProcessor = this.getProcessor();
            if (bl) {
                imageProcessor.snapshot();
            }
            rectangle = roi2.getBounds();
            imageProcessor.copyBits(clipboard.getProcessor(), rectangle.x, rectangle.y, n7);
            if (bl) {
                imageProcessor.reset(this.getMask());
            }
            this.updateAndDraw();
        } else if (roi2 != null) {
            roi2.startPaste(clipboard);
            Undo.setup(3, this);
        }
        this.changes = true;
    }

    public static ImagePlus getClipboard() {
        return clipboard;
    }

    public static void resetClipboard() {
        clipboard = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(int n) {
        Vector vector = listeners;
        synchronized (vector) {
            block8: for (int i = 0; i < listeners.size(); ++i) {
                ImageListener imageListener = (ImageListener)listeners.elementAt(i);
                switch (n) {
                    case 0: {
                        imageListener.imageOpened(this);
                        continue block8;
                    }
                    case 1: {
                        imageListener.imageClosed(this);
                        continue block8;
                    }
                    case 2: {
                        imageListener.imageUpdated(this);
                    }
                }
            }
        }
    }

    public static void addImageListener(ImageListener imageListener) {
        listeners.addElement(imageListener);
    }

    public static void removeImageListener(ImageListener imageListener) {
        listeners.removeElement(imageListener);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setOpenAsHyperStack(boolean bl) {
        this.openAsHyperStack = bl;
    }

    public boolean getOpenAsHyperStack() {
        return this.openAsHyperStack;
    }

    public boolean isComposite() {
        return this.compositeImage && this.getNChannels() > 1 && this instanceof CompositeImage;
    }

    public void setDisplayRange(double d, double d2) {
        if (this.ip != null) {
            this.ip.setMinAndMax(d, d2);
        }
    }

    public double getDisplayRangeMin() {
        return this.ip.getMin();
    }

    public double getDisplayRangeMax() {
        return this.ip.getMax();
    }

    public void setDisplayRange(double d, double d2, int n) {
        if (this.ip instanceof ColorProcessor) {
            ((ColorProcessor)this.ip).setMinAndMax(d, d2, n);
        } else {
            this.ip.setMinAndMax(d, d2);
        }
    }

    public void resetDisplayRange() {
        if (this.imageType == 1 && default16bitDisplayRange >= 8 && default16bitDisplayRange <= 16 && !this.getCalibration().isSigned16Bit()) {
            this.ip.setMinAndMax(0.0, Math.pow(2.0, default16bitDisplayRange) - 1.0);
        } else {
            this.ip.resetMinAndMax();
        }
    }

    public static void setDefault16bitRange(int n) {
        if (n != 8 && n != 10 && n != 12 && n != 15 && n != 16) {
            n = 0;
        }
        default16bitDisplayRange = n;
    }

    public static int getDefault16bitRange() {
        return default16bitDisplayRange;
    }

    public void updatePosition(int n, int n2, int n3) {
        this.position[0] = n;
        this.position[1] = n2;
        this.position[2] = n3;
    }

    public ImagePlus flatten() {
        int n;
        ImageCanvas imageCanvas;
        ImagePlus imagePlus = this.createImagePlus();
        String string = "Flat_" + this.getTitle();
        imagePlus.flatteningCanvas = imageCanvas = new ImageCanvas(imagePlus);
        imagePlus.setRoi(this.getRoi());
        ImageCanvas imageCanvas2 = this.getCanvas();
        Overlay overlay = this.getOverlay();
        int n2 = overlay != null ? overlay.size() : 0;
        int n3 = this.getStackSize();
        if (n2 > 1 && n2 == n3 && imageCanvas.stackLabels(overlay) && (n = this.getCurrentSlice() - 1) < n2) {
            overlay.temporarilyHide(0, n - 1);
            overlay.temporarilyHide(n + 1, n3 - 1);
        }
        imageCanvas.setOverlay(overlay);
        if (imageCanvas2 != null) {
            imageCanvas.setShowAllROIs(imageCanvas2.getShowAllROIs());
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(this.getImage(), 0, 0, null);
        imageCanvas.paint(graphics);
        imagePlus.flatteningCanvas = null;
        if (Recorder.record) {
            Recorder.recordCall("imp = IJ.getImage().flatten();");
        }
        return new ImagePlus(string, new ColorProcessor(bufferedImage));
    }

    public void setOverlay(Overlay overlay) {
        ImageCanvas imageCanvas = this.getCanvas();
        if (imageCanvas != null) {
            imageCanvas.setOverlay(overlay);
            overlay = null;
        } else {
            this.overlay = overlay;
        }
        this.setHideOverlay(false);
    }

    public void setOverlay(Shape shape, Color color, BasicStroke basicStroke) {
        if (shape == null) {
            this.setOverlay(null);
            return;
        }
        ShapeRoi shapeRoi = new ShapeRoi(shape);
        shapeRoi.setStrokeColor(color);
        shapeRoi.setStroke(basicStroke);
        this.setOverlay(new Overlay(shapeRoi));
    }

    public void setOverlay(Roi roi, Color color, int n, Color color2) {
        roi.setStrokeColor(color);
        roi.setStrokeWidth(n);
        roi.setFillColor(color2);
        this.setOverlay(new Overlay(roi));
    }

    public Overlay getOverlay() {
        ImageCanvas imageCanvas = this.getCanvas();
        if (imageCanvas != null) {
            return imageCanvas.getOverlay();
        }
        return this.overlay;
    }

    public void setDisplayList(Vector vector) {
        this.getCanvas().setDisplayList(vector);
    }

    public Vector getDisplayList() {
        return this.getCanvas().getDisplayList();
    }

    public void setDisplayList(Roi roi, Color color, int n, Color color2) {
        this.setOverlay(roi, color, n, color2);
    }

    public void setHideOverlay(boolean bl) {
        this.hideOverlay = bl;
        ImageCanvas imageCanvas = this.getCanvas();
        if (imageCanvas != null && imageCanvas.getOverlay() != null) {
            imageCanvas.repaint();
        }
    }

    public boolean getHideOverlay() {
        return this.hideOverlay;
    }

    public String toString() {
        return "imp[" + this.getTitle() + " " + this.width + "x" + this.height + "x" + this.getStackSize() + "]";
    }

    static {
        listeners = new Vector();
    }
}

