/*
 * Decompiled with CFR 0.152.
 */
package com.nexr.rhive.hive.udf;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPVector;
import org.rosuda.REngine.RList;
import org.rosuda.REngine.Rserve.RConnection;

@Description(name="RA", value="_FUNC_(export-name,arg1,arg2,...) - Returns the result of R aggregation function")
public class RUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        block3: for (int i = 0; i < parameters.length; ++i) {
            switch (((PrimitiveTypeInfo)parameters[i]).getPrimitiveCategory()) {
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case STRING: 
                case BOOLEAN: {
                    continue block3;
                }
                default: {
                    throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[i].getTypeName() + " is passed.");
                }
            }
        }
        return new GenericRUDAF();
    }

    public static class GenericRUDAF
    extends GenericUDAFEvaluator {
        private static RConnection rconnection;
        private static Map<String, String> funclist;
        private static String NULL;
        private static int STRING_TYPE;
        private static int NUMBER_TYPE;
        private ObjectInspectorConverters.Converter[] converters;
        private int[] types;
        private PrimitiveObjectInspector[] inputOIs;
        private Text result;
        private PrimitiveObjectInspector inputOI;
        private StructObjectInspector soi;
        private StructField resultField;
        private StructField fnNameField;
        private StringObjectInspector resultFieldOI;
        private StringObjectInspector fnNameFieldOI;
        private Object[] partialResult;
        boolean warned = false;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] arguments) throws HiveException {
            super.init(mode, arguments);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
                for (int i = 0; i < arguments.length; ++i) {
                    if (returnOIResolver.update(arguments[i])) continue;
                    throw new UDFArgumentTypeException(i, "Argument type \"" + arguments[i].getTypeName() + "\" is different from preceding arguments. " + "Previous type was \"" + arguments[i - 1].getTypeName() + "\"");
                }
                this.converters = new ObjectInspectorConverters.Converter[arguments.length];
                this.types = new int[arguments.length];
                this.inputOIs = new PrimitiveObjectInspector[arguments.length];
                ObjectInspector returnOI = returnOIResolver.get();
                if (returnOI == null) {
                    returnOI = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING);
                }
                for (int i = 0; i < arguments.length; ++i) {
                    this.converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[i], (ObjectInspector)returnOI);
                    if (arguments[i].getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveObjectInspector)arguments[i]).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                        this.types[i] = STRING_TYPE;
                        this.inputOIs[i] = (PrimitiveObjectInspector)arguments[i];
                        continue;
                    }
                    this.types[i] = NUMBER_TYPE;
                    this.inputOIs[i] = (PrimitiveObjectInspector)arguments[i];
                }
            } else {
                this.soi = (StructObjectInspector)arguments[0];
                this.resultField = this.soi.getStructFieldRef("result");
                this.fnNameField = this.soi.getStructFieldRef("fn_name");
                this.resultFieldOI = (StringObjectInspector)this.resultField.getFieldObjectInspector();
                this.fnNameFieldOI = (StringObjectInspector)this.fnNameField.getFieldObjectInspector();
            }
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<WritableStringObjectInspector> foi = new ArrayList<WritableStringObjectInspector>();
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("result");
                fname.add("fn_name");
                this.partialResult = new Object[2];
                this.partialResult[0] = new Text("");
                this.partialResult[1] = new Text("");
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            this.result = new Text("");
            return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            RResultAgg result = new RResultAgg();
            this.reset(result);
            return result;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            RResultAgg myagg = (RResultAgg)agg;
            myagg.funcName = "";
            myagg.empty = true;
            myagg.values = null;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block14: {
                String function_name = PrimitiveObjectInspectorUtils.getString((Object)parameters[0], (PrimitiveObjectInspector)this.inputOIs[0]);
                this.loadExportedRScript(function_name);
                try {
                    RResultAgg myagg = (RResultAgg)agg;
                    myagg.empty = false;
                    myagg.funcName = function_name;
                    StringBuffer argument = new StringBuffer();
                    if (myagg.values == null) {
                        argument.append("NULL, c(");
                    } else {
                        argument.append(myagg.values + ",c(");
                    }
                    for (int i = 1; i < parameters.length; ++i) {
                        if (this.types[i] == STRING_TYPE) {
                            String value = PrimitiveObjectInspectorUtils.getString((Object)parameters[i], (PrimitiveObjectInspector)this.inputOIs[i]);
                            if (value == null) {
                                argument.append("NULL");
                            } else {
                                argument.append("\"" + value + "\"");
                            }
                        } else if (parameters[i] == null) {
                            argument.append("NULL");
                        } else {
                            double value = PrimitiveObjectInspectorUtils.getDouble((Object)parameters[i], (PrimitiveObjectInspector)this.inputOIs[i]);
                            argument.append(value);
                        }
                        if (i >= parameters.length - 1) continue;
                        argument.append(",");
                    }
                    REXP rdata = null;
                    try {
                        rdata = this.getConnection().eval(function_name + "(" + argument.toString() + "))");
                    }
                    catch (Exception e) {
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        e.printStackTrace(new PrintStream(output));
                        throw new HiveException(new String(output.toByteArray()) + " -- fail to eval : " + function_name + "(" + argument.toString() + ")");
                    }
                    if (rdata != null) {
                        this.tranformR2Hive(myagg, rdata, false);
                    }
                }
                catch (NumberFormatException e) {
                    if (this.warned) break block14;
                    this.warned = true;
                }
            }
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            block5: {
                try {
                    RResultAgg myagg = (RResultAgg)agg;
                    String function_name = myagg.funcName + ".partial";
                    REXP rdata = null;
                    try {
                        rdata = myagg.values == null ? this.getConnection().eval(function_name + "(NULL)") : this.getConnection().eval(function_name + "(" + myagg.values + ")");
                    }
                    catch (Exception e) {
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        e.printStackTrace(new PrintStream(output));
                        throw new HiveException(new String(output.toByteArray()) + " -- fail to eval : " + function_name + "(" + myagg.values + ")");
                    }
                    if (rdata != null) {
                        this.tranformR2Hive(myagg, rdata, false);
                    }
                    ((Text)this.partialResult[0]).set(myagg.values);
                    ((Text)this.partialResult[1]).set(myagg.funcName);
                }
                catch (NumberFormatException e) {
                    if (this.warned) break block5;
                    this.warned = true;
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(output));
                    throw new HiveException(new String(output.toByteArray()));
                }
            }
            return this.partialResult;
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            block7: {
                if (partial != null) {
                    RResultAgg myagg = (RResultAgg)agg;
                    Object partialResult = this.soi.getStructFieldData(partial, this.resultField);
                    String partial_value = this.resultFieldOI.getPrimitiveJavaObject(partialResult);
                    if (myagg.funcName == null || myagg.funcName.equals("")) {
                        Object partialFnName = this.soi.getStructFieldData(partial, this.fnNameField);
                        myagg.funcName = this.fnNameFieldOI.getPrimitiveJavaObject(partialFnName);
                    }
                    myagg.empty = false;
                    try {
                        this.loadExportedRScript(myagg.funcName);
                        String function_name = myagg.funcName + ".merge";
                        REXP rdata = null;
                        try {
                            rdata = myagg.values == null ? this.getConnection().eval(function_name + "(NULL," + partial_value + ")") : this.getConnection().eval(function_name + "(" + myagg.values + "," + partial_value + ")");
                        }
                        catch (Exception e) {
                            ByteArrayOutputStream output = new ByteArrayOutputStream();
                            e.printStackTrace(new PrintStream(output));
                            throw new HiveException(new String(output.toByteArray()) + " -- fail to eval : " + function_name + "(" + myagg.values + "," + partial_value + ")");
                        }
                        if (rdata != null) {
                            this.tranformR2Hive(myagg, rdata, false);
                        }
                    }
                    catch (NumberFormatException e) {
                        if (this.warned) break block7;
                        this.warned = true;
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        e.printStackTrace(new PrintStream(output));
                        throw new HiveException(new String(output.toByteArray()));
                    }
                }
            }
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            block6: {
                RResultAgg myagg = (RResultAgg)agg;
                if (myagg.empty) {
                    return null;
                }
                try {
                    String function_name = myagg.funcName + ".terminate";
                    REXP rdata = null;
                    try {
                        rdata = myagg.values == null ? this.getConnection().eval(function_name + "(NULL)") : this.getConnection().eval(function_name + "(" + myagg.values + ")");
                    }
                    catch (Exception e) {
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        e.printStackTrace(new PrintStream(output));
                        throw new HiveException(new String(output.toByteArray()) + " -- fail to eval : " + function_name + "(" + myagg.values + ")");
                    }
                    if (rdata != null) {
                        this.tranformR2Hive(myagg, rdata, true);
                    }
                    this.result.set(myagg.values);
                }
                catch (NumberFormatException e) {
                    if (this.warned) break block6;
                    this.warned = true;
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(output));
                    throw new HiveException(new String(output.toByteArray()));
                }
            }
            return this.result;
        }

        private RConnection getConnection() throws UDFArgumentException {
            if (rconnection == null || !rconnection.isConnected()) {
                try {
                    rconnection = new RConnection("127.0.0.1");
                }
                catch (Exception e) {
                    throw new UDFArgumentException(e.toString());
                }
            }
            return rconnection;
        }

        private void loadExportedRScript(String export_name) throws HiveException {
            if (!funclist.containsKey(export_name)) {
                try {
                    REXP rhive_data = this.getConnection().eval("Sys.getenv('RHIVE_DATA')");
                    String srhive_data = null;
                    if (rhive_data != null) {
                        srhive_data = rhive_data.asString();
                    }
                    if (srhive_data == null || srhive_data == "") {
                        this.getConnection().eval("load(file=paste('/tmp','/" + export_name + ".Rdata',sep=''))");
                    } else {
                        this.getConnection().eval("load(file=paste(Sys.getenv('RHIVE_DATA'),'/" + export_name + ".Rdata',sep=''))");
                    }
                }
                catch (Exception e) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(output));
                    throw new HiveException(new String(output.toByteArray()));
                }
                funclist.put(export_name, NULL);
            }
        }

        private void tranformR2Hive(RResultAgg myagg, REXP rdata, boolean isTerminate) throws HiveException {
            block7: {
                try {
                    if (rdata instanceof REXPGenericVector) {
                        StringBuffer sb = new StringBuffer();
                        REXPGenericVector list = (REXPGenericVector)rdata;
                        this.handleList(list, sb, isTerminate);
                        myagg.values = sb.toString();
                        break block7;
                    }
                    if (rdata instanceof REXPVector) {
                        StringBuffer sb = new StringBuffer();
                        REXPVector vector = (REXPVector)rdata;
                        this.handleVector(vector, sb, isTerminate);
                        myagg.values = sb.toString();
                        break block7;
                    }
                    if (rdata instanceof REXPString) {
                        myagg.values = "'" + rdata.asString() + "'";
                        break block7;
                    }
                    if (rdata instanceof REXPDouble) {
                        myagg.values = Double.toString(rdata.asDouble());
                        break block7;
                    }
                    if (rdata instanceof REXPInteger) {
                        myagg.values = Integer.toString(rdata.asInteger());
                        break block7;
                    }
                    throw new HiveException("not support this type : " + rdata.toString());
                }
                catch (Exception e) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(output));
                    throw new HiveException(new String(output.toByteArray()));
                }
            }
        }

        private void handleList(REXPGenericVector list, StringBuffer sb, boolean isTerminate) throws REXPMismatchException, HiveException {
            RList rlist = list.asList();
            if (!isTerminate) {
                sb.append("list(");
            }
            for (int i = 0; i < rlist.size(); ++i) {
                Object result = rlist.get(i);
                if (result instanceof REXPVector) {
                    REXPVector vector = (REXPVector)result;
                    this.handleVector(vector, sb, isTerminate);
                } else if (result instanceof REXPString) {
                    sb.append("'" + ((REXPString)result).asString() + "'");
                } else if (result instanceof REXPDouble) {
                    sb.append(Double.toString(((REXPDouble)result).asDouble()));
                } else if (result instanceof REXPInteger) {
                    sb.append(Integer.toString(((REXPInteger)result).asInteger()));
                } else {
                    throw new HiveException("only support vector, string, double and integer in List");
                }
                if (i >= rlist.size() - 1) continue;
                sb.append(",");
            }
            if (!isTerminate) {
                sb.append(")");
            }
        }

        private void handleVector(REXPVector vector, StringBuffer sb, boolean isTerminate) throws REXPMismatchException, HiveException {
            if (!isTerminate) {
                sb.append("c(");
            }
            if (vector.isNumeric()) {
                double[] values = vector.asDoubles();
                for (int j = 0; j < values.length; ++j) {
                    sb.append(Double.toString(values[j]));
                    if (j >= values.length - 1) continue;
                    sb.append(",");
                }
            } else if (vector.isString()) {
                String[] values = vector.asStrings();
                for (int j = 0; j < values.length; ++j) {
                    sb.append("'" + values[j] + "'");
                    if (j >= values.length - 1) continue;
                    sb.append(",");
                }
            } else {
                throw new HiveException("only support numeric and string in vector");
            }
            if (!isTerminate) {
                sb.append(")");
            }
        }

        static {
            funclist = new Hashtable<String, String>();
            NULL = "";
            STRING_TYPE = 1;
            NUMBER_TYPE = 0;
        }

        static class RResultAgg
        implements GenericUDAFEvaluator.AggregationBuffer {
            boolean empty;
            String funcName;
            String values;

            RResultAgg() {
            }
        }
    }
}

