/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import javax.management.ObjectName;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.metrics.RpcMetrics;
import org.apache.hadoop.ipc.metrics.RpcMgtMBean;
import org.apache.hadoop.metrics.util.MBeanUtil;

class RpcMgt
implements RpcMgtMBean {
    private RpcMetrics myMetrics;
    private Server myServer;
    private ObjectName mbeanName;

    RpcMgt(String serviceName, String port, RpcMetrics metrics, Server server) {
        this.myMetrics = metrics;
        this.myServer = server;
        this.mbeanName = MBeanUtil.registerMBean(serviceName, "RpcStatisticsForPort" + port, this);
    }

    public void shutdown() {
        if (this.mbeanName != null) {
            MBeanUtil.unregisterMBean(this.mbeanName);
        }
    }

    @Override
    public long getRpcOpsAvgProcessingTime() {
        return this.myMetrics.rpcProcessingTime.getPreviousIntervalAverageTime();
    }

    @Override
    public long getRpcOpsAvgProcessingTimeMax() {
        return this.myMetrics.rpcProcessingTime.getMaxTime();
    }

    @Override
    public long getRpcOpsAvgProcessingTimeMin() {
        return this.myMetrics.rpcProcessingTime.getMinTime();
    }

    @Override
    public long getRpcOpsAvgQueueTime() {
        return this.myMetrics.rpcQueueTime.getPreviousIntervalAverageTime();
    }

    @Override
    public long getRpcOpsAvgQueueTimeMax() {
        return this.myMetrics.rpcQueueTime.getMaxTime();
    }

    @Override
    public long getRpcOpsAvgQueueTimeMin() {
        return this.myMetrics.rpcQueueTime.getMinTime();
    }

    @Override
    public int getRpcOpsNumber() {
        return this.myMetrics.rpcProcessingTime.getPreviousIntervalNumOps();
    }

    @Override
    public int getNumOpenConnections() {
        return this.myServer.getNumOpenConnections();
    }

    @Override
    public int getCallQueueLen() {
        return this.myServer.getCallQueueLen();
    }

    @Override
    public void resetAllMinMax() {
        this.myMetrics.rpcProcessingTime.resetMinMax();
        this.myMetrics.rpcQueueTime.resetMinMax();
    }
}

