% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/report.R
\name{get_rt}
\alias{get_rt}
\title{Get the Anaytics data from Real Time Reporting API for a view (profile)}
\usage{
get_rt(profile.id, metrics = "rt:activeUsers", dimensions = NULL,
  sort = NULL, filters = NULL, max.results = NULL, token,
  verbose = getOption("rga.verbose"))
}
\arguments{
\item{profile.id}{integer or character. Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the Analytics view (profile) ID. Can be obtained using the \code{\link{list_profiles}} or via the web interface Google Analytics.}

\item{metrics}{character. A comma-separated list of real time metrics. E.g., \code{"rt:activeUsers"}. At least one metric must be specified.}

\item{dimensions}{character. A comma-separated list of real time dimensions. E.g., \code{"rt:medium,rt:city"}.}

\item{sort}{character. A comma-separated list of dimensions or metrics that determine the sort order for real time data.}

\item{filters}{character. A comma-separated list of dimension or metric filters to be applied to real time data.}

\item{max.results}{integer. The maximum number of entries to include in this feed.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
A data frame including the real time data for a view (profile).
}
\description{
Get the Anaytics data from Real Time Reporting API for a view (profile)
}
\examples{
\dontrun{
# get token data
authorize(client.id = "myID", client.secret = "mySecret")
# get report data
ga_data <- get_rt("myProfileID", metrics = "rt:activeUsers", dimensions = "rt:source,rt:medium")
# get active users in realtime (press Esc to abort)
while (TRUE) {
    cat("\\014")
    print(get_rt("myProfileID", metrics = "rt:activeUsers"))
    Sys.sleep(2)
}
}
}
\references{
\href{https://developers.google.com/analytics/devguides/reporting/realtime/dimsmets/}{Real Time Reporting API - Dimensions & Metrics Reference}
}
\seealso{
\code{\link{authorize}}

Other The Google Analytics Reporting API: \code{\link{get_firstdate}};
  \code{\link{get_ga}}; \code{\link{get_mcf}}
}

