/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.inspector.CustomizableInspector;
import freak.core.modulesupport.inspector.FileEditor;
import freak.core.modulesupport.inspector.Inspector;
import freak.core.view.swingsupport.FreakTitledBorderModel;
import freak.module.view.StdView;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class FileWriter
extends StdView
implements Configurable {
    private static int fileNameCounter = 0;
    private File file;
    private long writePosition;
    private transient RandomAccessFile out;
    private FreakTitledBorderModel borderModel = new FreakTitledBorderModel();
    private boolean recreate;

    public FileWriter(Schedule schedule) {
        super(schedule);
        this.setPropertyFile(new File(""));
    }

    public String getDescription() {
        return "Writes textual data into a file.";
    }

    public String getName() {
        return "File Writer";
    }

    public void update(Object o) {
        super.update(o);
        if (this.recreate) {
            this.recreate = false;
            try {
                this.out = new RandomAccessFile(this.file, "rw");
                this.out.seek(this.writePosition);
            }
            catch (IOException exc) {
                this.out = null;
            }
        }
        if (this.out != null) {
            String newText = this.extractTextFromObject(o);
            try {
                this.out.write(FileWriter.encode(String.valueOf(newText) + "\n"));
                this.writePosition = this.out.getFilePointer();
                this.setText(newText);
            }
            catch (IOException exc) {
                this.out = null;
                this.setText("Error writing to file " + this.file + ".\nNo data is being written.");
            }
        } else {
            this.setText("Error writing to file " + this.file + ".\nNo data is being written.");
        }
    }

    public JPanel createPanel() {
        this.recreate = true;
        JPanel panel = super.createPanel();
        TitledBorder border = new TitledBorder("");
        panel.setBorder(border);
        this.borderModel.setView(border);
        return panel;
    }

    public void setPropertyFile(File newFile) {
        if (newFile.equals(this.file)) {
            return;
        }
        this.file = newFile;
        if (this.file.getName().equals("")) {
            this.file = FileWriter.createNewFile();
            this.borderModel.setTitle("Writing to auto-generated file");
        } else {
            this.borderModel.setTitle("Writing to " + this.file);
        }
        this.borderModel.flush();
        this.writePosition = 0L;
        this.recreate = true;
    }

    public File getPropertyFile() {
        return this.file;
    }

    public String getShortDescriptionForFile() {
        return "Log file";
    }

    public String getLongDescriptionForFile() {
        return "The name of the log file the output is to be written.";
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.out != null) {
            this.out.close();
        }
    }

    public Inspector getInspector() {
        CustomizableInspector inspector = (CustomizableInspector)super.getInspector();
        inspector.customize(File.class, new JTable().getDefaultRenderer(String.class), new FileEditor(1));
        return inspector;
    }

    private static File createNewFile() {
        File result = null;
        do {
            String fileName = String.valueOf(fileNameCounter);
            while (fileName.length() < 4) {
                fileName = "0" + fileName;
            }
            fileName = "data" + fileName + ".log";
            result = new File(fileName);
            ++fileNameCounter;
        } while (result.exists());
        return result;
    }

    private static byte[] encode(String data) {
        try {
            ByteArrayOutputStream sink = new ByteArrayOutputStream();
            OutputStreamWriter push = new OutputStreamWriter(sink);
            push.write(data);
            push.close();
            return sink.toByteArray();
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }
}

