/*
 * Decompiled with CFR 0.152.
 */
package freak.core.modulesupport;

import freak.Freak;
import freak.core.modulesupport.ClassCollector;
import freak.core.modulesupport.ClassPersistenceHandler;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.modulesupport.XMLizeException;
import freak.core.util.Base64;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.border.BevelBorder;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;

public class PersistenceManager {
    private int lastId = -1;
    private Map handlerMap;
    private Map classHandler = new HashMap();
    private List objects = new ArrayList();
    private ArrayPersistenceHandler arrayHandler;
    private static Class[] allHandlers = ClassCollector.getAllImplementors(ClassPersistenceHandler.class);

    public static void init() {
    }

    private PersistenceManager() {
        int i = 0;
        while (i < allHandlers.length) {
            Class handles;
            ClassPersistenceHandler handler = null;
            try {
                handler = (ClassPersistenceHandler)PersistenceManager.newObject(allHandlers[i], new Object[]{this});
            }
            catch (UnsupportedEnvironmentException unsupportedEnvironmentException) {
                // empty catch block
            }
            if (handler != null && (handles = handler.handles()) != null) {
                this.classHandler.put(handles, handler);
            }
            ++i;
        }
        this.arrayHandler = new ArrayPersistenceHandler(this);
    }

    private ClassPersistenceHandler getHandlerFor(Class c) throws XMLizeException {
        ClassPersistenceHandler cph = (ClassPersistenceHandler)this.classHandler.get(c);
        if (cph != null) {
            return cph;
        }
        if (c.isArray()) {
            return this.arrayHandler;
        }
        ArrayList<Class> handledList = new ArrayList<Class>();
        for (Class handled : this.classHandler.keySet()) {
            if (!handled.isInterface() || !handled.isAssignableFrom(c) || handled == Serializable.class) continue;
            boolean ignoreHandle = false;
            int i = 0;
            while (i < handledList.size()) {
                if (handled.isAssignableFrom((Class)handledList.get(i))) {
                    ignoreHandle = true;
                    break;
                }
                ++i;
            }
            if (ignoreHandle) continue;
            i = handledList.size() - 1;
            while (i >= 0) {
                if (((Class)handledList.get(i)).isAssignableFrom(handled)) {
                    handledList.remove(i);
                }
                --i;
            }
            handledList.add(handled);
        }
        if (handledList.size() != 1) {
            if (Serializable.class.isAssignableFrom(c)) {
                return (ClassPersistenceHandler)this.classHandler.get(Serializable.class);
            }
            throw new XMLizeException("found " + handledList.size() + " handlers for " + c.getName());
        }
        return (ClassPersistenceHandler)this.classHandler.get(handledList.get(0));
    }

    public Element toXML(Object o) throws XMLizeException {
        if (o == null) {
            return new Element("null");
        }
        return this.toXML(o, o.getClass());
    }

    public Element toXML(Object o, Class forcedType) throws XMLizeException {
        Element e;
        if (o == null) {
            return new Element("null");
        }
        int i = 0;
        while (i < this.objects.size()) {
            if (this.objects.get(i) == o && o.getClass() != String.class) {
                Freak.debug("WARNING: reference persistence not tested yet", 2);
                return new Element("ref").setAttribute("id", String.valueOf(i));
            }
            ++i;
        }
        ClassPersistenceHandler handler = this.getHandlerFor(forcedType);
        if (handler == null) {
            return null;
        }
        int id = this.objects.size();
        if (!(o instanceof String)) {
            this.objects.add(o);
        }
        try {
            e = handler.toXML(o);
        }
        catch (Exception e1) {
            throw new XMLizeException(e1);
        }
        e.setAttribute("handler", handler.getClass().getName());
        if (!(o instanceof String)) {
            e.setAttribute("id", String.valueOf(id));
        }
        return e;
    }

    public Object fromXML(Element e) throws XMLizeException {
        if (e.getName().equals("ref")) {
            try {
                Object o = this.objects.get(e.getAttribute("id").getIntValue());
                if (o == null) {
                    throw new XMLizeException("could not find object with id " + e.getAttribute("id").getIntValue());
                }
                return o;
            }
            catch (DataConversionException e1) {
                throw new XMLizeException("id Attribute is missing or has wrong format", e1);
            }
        }
        if (e.getName().equals("null")) {
            return null;
        }
        String handlerName = "";
        handlerName = e.getAttribute("handler") != null ? e.getAttribute("handler").getValue() : (String)this.handlerMap.get(e.getName());
        Object o = null;
        try {
            o = PersistenceManager.newObjectByString(handlerName, new Object[]{this});
        }
        catch (UnsupportedEnvironmentException e2) {
            throw new XMLizeException("failed to create handler", e2);
        }
        if (o instanceof ClassPersistenceHandler) {
            Object result;
            if (e.getAttribute("id") != null) {
                try {
                    this.lastId = e.getAttribute("id").getIntValue();
                }
                catch (DataConversionException e1) {
                    this.lastId = -1;
                }
            } else {
                this.lastId = -1;
            }
            try {
                result = ((ClassPersistenceHandler)o).fromXML(e);
            }
            catch (Exception e3) {
                throw new XMLizeException(e3);
            }
            try {
                if (e.getAttribute("id") != null) {
                    this.registerObject(result, e.getAttribute("id").getIntValue());
                }
            }
            catch (DataConversionException e1) {
                throw new XMLizeException(e1);
            }
            return result;
        }
        throw new XMLizeException("no handler found");
    }

    public void registerObject(Object o) {
        if (this.lastId > 0) {
            while (this.objects.size() <= this.lastId) {
                this.objects.add(null);
            }
            this.objects.set(this.lastId, o);
        }
    }

    private void registerObject(Object o, int forcedId) {
        int tmp = this.lastId;
        this.lastId = forcedId;
        this.registerObject(o);
        this.lastId = tmp;
    }

    public static Document XMLize(Object o) throws XMLizeException {
        PersistenceManager pm = new PersistenceManager();
        Element e = pm.toXML(o);
        HashMap map = new HashMap();
        PersistenceManager.buildHandlerMap(e, map);
        PersistenceManager.cleanHandlerAttributes(e, map);
        HashSet col = new HashSet();
        PersistenceManager.buildUsedIdsList(e, col);
        PersistenceManager.cleanIdAttributes(e, col);
        Element handlerElement = new Element("handler");
        for (String elementName : map.keySet()) {
            if (map.get(elementName) == null) continue;
            handlerElement.addContent(new Element(elementName).setText((String)map.get(elementName)));
        }
        Document doc = new Document(new Element("FreakPersistence").addContent(handlerElement).addContent(e));
        return doc;
    }

    private static void buildHandlerMap(Element e, Map map) {
        if (e.getAttribute("handler") != null) {
            if (map.containsKey(e.getName())) {
                if (map.get(e.getName()) == null || !((String)map.get(e.getName())).equals(e.getAttributeValue("handler"))) {
                    map.put(e.getName(), null);
                }
            } else {
                map.put(e.getName(), e.getAttributeValue("handler"));
            }
        } else if (map.containsKey(e.getName())) {
            map.put(e.getName(), null);
        }
        Iterator iter = e.getChildren().iterator();
        while (iter.hasNext()) {
            PersistenceManager.buildHandlerMap((Element)iter.next(), map);
        }
    }

    private static void cleanHandlerAttributes(Element e, Map map) {
        if (e.getAttribute("handler") != null && map.get(e.getName()) != null) {
            e.removeAttribute("handler");
        }
        Iterator iter = e.getChildren().iterator();
        while (iter.hasNext()) {
            PersistenceManager.cleanHandlerAttributes((Element)iter.next(), map);
        }
    }

    private static void buildUsedIdsList(Element e, Collection col) {
        if (e.getName().equals("ref")) {
            try {
                col.add(new Integer(e.getAttribute("id").getIntValue()));
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        Iterator iter = e.getChildren().iterator();
        while (iter.hasNext()) {
            PersistenceManager.buildUsedIdsList((Element)iter.next(), col);
        }
    }

    private static void cleanIdAttributes(Element e, Collection col) {
        if (e.getAttribute("id") != null) {
            try {
                if (!col.contains(new Integer(e.getAttribute("id").getIntValue()))) {
                    e.removeAttribute("id");
                }
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        Iterator iter = e.getChildren().iterator();
        while (iter.hasNext()) {
            PersistenceManager.cleanIdAttributes((Element)iter.next(), col);
        }
    }

    public static Object DeXMLize(Document doc) throws XMLizeException {
        Element handlers = doc.getRootElement().getChild("handler");
        HashMap<String, String> map = new HashMap<String, String>();
        for (Element entry : handlers.getChildren()) {
            map.put(entry.getName(), entry.getText());
        }
        handlers.detach();
        PersistenceManager pm = new PersistenceManager();
        pm.handlerMap = map;
        try {
            return pm.fromXML((Element)doc.getRootElement().getChildren().get(0));
        }
        catch (Exception e) {
            throw new XMLizeException(e);
        }
    }

    private static Object newObjectByString(String className, Object[] param) throws UnsupportedEnvironmentException, XMLizeException {
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new XMLizeException(e);
        }
        return PersistenceManager.newObject(c, param);
    }

    private static Object newObjectByString(String className) throws UnsupportedEnvironmentException, XMLizeException {
        return PersistenceManager.newObjectByString(className, new Object[0]);
    }

    private static Object newObject(Class c, Object[] param) throws UnsupportedEnvironmentException {
        if (c == null) {
            return null;
        }
        Constructor<?>[] constr = c.getConstructors();
        Object o = null;
        int i = 0;
        while (i < constr.length) {
            try {
                o = constr[i].newInstance(param);
                return o;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof UnsupportedEnvironmentException) {
                    throw new UnsupportedEnvironmentException();
                }
                System.err.println("The constructor of " + c.getName() + " caused an exception:\n" + e.getTargetException().toString());
                e.printStackTrace();
                return null;
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (Exception e) {
                System.err.println("The constructor of " + c.getName() + " doesn't work properly.\n" + e.toString());
                e.printStackTrace();
            }
            ++i;
        }
        System.err.println("The class " + c.getName() + " doesn't have a constructor with the expected signature!");
        return null;
    }

    public static class Serializer
    implements ClassPersistenceHandler {
        private PersistenceManager pm = null;

        public Serializer(PersistenceManager pm) {
            this.pm = pm;
        }

        public Element toXML(Object o) {
            System.out.println("WARNING: Had to use Serializer for " + o.getClass().getName());
            return new Element("object").addContent(new CDATA(Base64.encodeObject((Serializable)o))).addContent(new Comment("class=" + o.getClass().getName()));
        }

        public Object fromXML(Element e) {
            return Base64.decodeToObject(e.getText());
        }

        public Class handles() {
            return Serializable.class;
        }
    }

    public static class IntegerPersistenceHandler
    implements ClassPersistenceHandler {
        public IntegerPersistenceHandler(PersistenceManager pm) {
        }

        public Element toXML(Object o) {
            return new Element("Integer").addContent(new Text(((Integer)o).toString()));
        }

        public Object fromXML(Element e) {
            return Integer.valueOf(e.getText());
        }

        public Class handles() {
            return Integer.class;
        }
    }

    public static class DoublePersistenceHandler
    implements ClassPersistenceHandler {
        public DoublePersistenceHandler(PersistenceManager pm) {
        }

        public Element toXML(Object o) {
            return new Element("Double").addContent(new Text(((Double)o).toString()));
        }

        public Object fromXML(Element e) {
            return Double.valueOf(e.getText());
        }

        public Class handles() {
            return Double.class;
        }
    }

    public static class BooleanPersistenceHandler
    implements ClassPersistenceHandler {
        public BooleanPersistenceHandler(PersistenceManager pm) {
        }

        public Element toXML(Object o) {
            return new Element("Boolean").addContent(new Text(((Boolean)o).toString()));
        }

        public Object fromXML(Element e) {
            return Boolean.valueOf(e.getText());
        }

        public Class handles() {
            return Boolean.class;
        }
    }

    public static class StringPersistenceHandler
    implements ClassPersistenceHandler {
        public StringPersistenceHandler(PersistenceManager pm) {
        }

        public Element toXML(Object o) {
            return new Element("String").addContent(new Text((String)o));
        }

        public Object fromXML(Element e) {
            return e.getText();
        }

        public Class handles() {
            return String.class;
        }
    }

    public static class ColorPersistenceHandler
    implements ClassPersistenceHandler {
        public ColorPersistenceHandler(PersistenceManager pm) {
        }

        public Element toXML(Object o) {
            Color c = (Color)o;
            Element result = new Element("Color");
            result.setAttribute("red", String.valueOf(c.getRed()));
            result.setAttribute("green", String.valueOf(c.getGreen()));
            result.setAttribute("blue", String.valueOf(c.getBlue()));
            return result;
        }

        public Object fromXML(Element e) throws DataConversionException {
            int red = e.getAttribute("red").getIntValue();
            int green = e.getAttribute("green").getIntValue();
            int blue = e.getAttribute("blue").getIntValue();
            Color c = new Color(red, green, blue);
            return c;
        }

        public Class handles() {
            return Color.class;
        }
    }

    public static class BevelBorderPersistenceHandler
    implements ClassPersistenceHandler {
        public BevelBorderPersistenceHandler(PersistenceManager pm) {
        }

        public Element toXML(Object o) {
            BevelBorder border = (BevelBorder)o;
            Element result = new Element("BevelBorder");
            result.setAttribute("bevelType", String.valueOf(border.getBevelType()));
            return result;
        }

        public Object fromXML(Element e) throws DataConversionException {
            return new BevelBorder(e.getAttribute("bevelType").getIntValue());
        }

        public Class handles() {
            return BevelBorder.class;
        }
    }

    public static class PointPersistenceHandler
    implements ClassPersistenceHandler {
        public PointPersistenceHandler(PersistenceManager pm) {
        }

        public Element toXML(Object o) {
            Point point = (Point)o;
            Element result = new Element("Point");
            result.setAttribute("x", String.valueOf(point.x));
            result.setAttribute("y", String.valueOf(point.y));
            return result;
        }

        public Object fromXML(Element e) throws DataConversionException {
            return new Point(e.getAttribute("x").getIntValue(), e.getAttribute("y").getIntValue());
        }

        public Class handles() {
            return Point.class;
        }
    }

    public static class RectanglePersistenceHandler
    implements ClassPersistenceHandler {
        public RectanglePersistenceHandler(PersistenceManager pm) {
        }

        public Element toXML(Object o) {
            Rectangle rect = (Rectangle)o;
            Element result = new Element("Rectangle");
            result.setAttribute("height", String.valueOf(rect.height));
            result.setAttribute("width", String.valueOf(rect.width));
            result.setAttribute("x", String.valueOf(rect.x));
            result.setAttribute("y", String.valueOf(rect.y));
            return result;
        }

        public Object fromXML(Element e) throws DataConversionException {
            return new Rectangle(e.getAttribute("x").getIntValue(), e.getAttribute("y").getIntValue(), e.getAttribute("width").getIntValue(), e.getAttribute("height").getIntValue());
        }

        public Class handles() {
            return Rectangle.class;
        }
    }

    public static class ListPersistenceHandler
    implements ClassPersistenceHandler {
        private PersistenceManager pm = null;

        public ListPersistenceHandler(PersistenceManager pm) {
            this.pm = pm;
        }

        public Element toXML(Object o) throws XMLizeException {
            List list = (List)o;
            Element result = new Element("List");
            result.setAttribute("type", o.getClass().getName());
            int i = 0;
            while (i < list.size()) {
                result.addContent(this.pm.toXML(list.get(i)));
                ++i;
            }
            return result;
        }

        public Object fromXML(Element e) throws UnsupportedEnvironmentException, XMLizeException {
            List result = (List)PersistenceManager.newObjectByString(e.getAttributeValue("type"));
            this.pm.registerObject(result);
            for (Element child : e.getChildren()) {
                result.add(this.pm.fromXML(child));
            }
            return result;
        }

        public Class handles() {
            return List.class;
        }
    }

    public static class MapPersistenceHandler
    implements ClassPersistenceHandler {
        private PersistenceManager pm = null;

        public MapPersistenceHandler(PersistenceManager pm) {
            this.pm = pm;
        }

        public Element toXML(Object o) throws XMLizeException {
            Map map = (Map)o;
            Element result = new Element("Map");
            result.setAttribute("type", o.getClass().getName());
            for (Object key : map.keySet()) {
                result.addContent(this.pm.toXML(key));
                result.addContent(this.pm.toXML(map.get(key)));
            }
            return result;
        }

        public Object fromXML(Element e) throws UnsupportedEnvironmentException, XMLizeException {
            Map result = (Map)PersistenceManager.newObjectByString(e.getAttributeValue("type"));
            this.pm.registerObject(result);
            Iterator itr = e.getChildren().iterator();
            while (itr.hasNext()) {
                Element key = (Element)itr.next();
                Element value = (Element)itr.next();
                result.put(this.pm.fromXML(key), this.pm.fromXML(value));
            }
            return result;
        }

        public Class handles() {
            return Map.class;
        }
    }

    public static class ArrayPersistenceHandler
    implements ClassPersistenceHandler {
        private PersistenceManager pm;

        public ArrayPersistenceHandler(PersistenceManager pm) {
            this.pm = pm;
        }

        public Element toXML(Object o) throws XMLizeException {
            Object[] array = (Object[])o;
            Element entry = new Element("Array");
            entry.setAttribute("type", o.getClass().getComponentType().getName());
            int i = 0;
            while (i < array.length) {
                entry.addContent(this.pm.toXML(array[i]));
                ++i;
            }
            return entry;
        }

        public Object fromXML(Element e) throws ClassNotFoundException, XMLizeException {
            List l = e.getChildren();
            Class<?> cl = null;
            cl = Class.forName(e.getAttribute("type").getValue());
            Object array = Array.newInstance(cl, l.size());
            this.pm.registerObject(array);
            Iterator iter = l.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Element el = (Element)iter.next();
                ((Object[])array)[i] = this.pm.fromXML(el);
                ++i;
            }
            return array;
        }

        public Class handles() {
            return null;
        }
    }
}

