/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.control.Schedule;
import freak.core.fitness.FitnessTransformer;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.ModuleCollector;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.gui.JButtonFactory;
import freak.gui.ModuleList;
import freak.gui.scheduleeditor.HelpDialog;
import freak.gui.scheduleeditor.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FitnessTransformerDialog
extends JDialog {
    private Schedule schedule;
    private ModuleCollector moduleCollector;
    private Module[] fitnessTransformers;
    private List currentFitnessTransformers;
    private JButton buAddTransformer;
    private JButton buClose;
    private JButton buConfigFitnessTransformer;
    private JButton buHelp;
    private JButton buRemoveTransformer;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JScrollPane jScrollPane11;
    private JScrollPane jScrollPane12;
    private JScrollPane jScrollPane17;
    private JList listAvailableTransformers;
    private JList listCurrentTransformer;
    private JTextArea taDescrFitnessTransformer;

    public FitnessTransformerDialog(Dialog parent, Schedule schedule) {
        super(parent, true);
        this.initComponents();
        this.setSize(530, 350);
        this.setLocationRelativeTo(parent);
        this.schedule = schedule;
        this.moduleCollector = new ModuleCollector(schedule);
        this.fitnessTransformers = this.moduleCollector.getFitnessTransformers();
        this.currentFitnessTransformers = Util.getFitnessTransformersFrom(schedule);
        this.initFitnessTransformers();
    }

    public List getFitnessTransformers() {
        return this.currentFitnessTransformers;
    }

    private void initFitnessTransformers() {
        ((ModuleList)this.listAvailableTransformers).setModules(this.fitnessTransformers, null);
        this.listAvailableTransformers.setEnabled(this.fitnessTransformers.length > 0);
        this.buAddTransformer.setEnabled(this.fitnessTransformers.length > 0);
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (FitnessTransformer ft : this.currentFitnessTransformers) {
            String name = ft.getName();
            if (ft instanceof Configurable) {
                Configurable confobj = (Configurable)((Object)ft);
                String confstr = confobj.getConfiguration().getDescription();
                name = String.valueOf(name) + " (" + confstr + ")";
            }
            listModel.addElement(name);
        }
        this.listCurrentTransformer.setModel(listModel);
    }

    private void initComponents() {
        this.jPanel10 = new JPanel();
        this.jPanel12 = new JPanel();
        this.jScrollPane11 = new JScrollPane();
        this.listAvailableTransformers = new ModuleList();
        this.jScrollPane12 = new JScrollPane();
        this.taDescrFitnessTransformer = new JTextArea();
        this.buAddTransformer = JButtonFactory.newButton();
        this.jPanel13 = new JPanel();
        this.jScrollPane17 = new JScrollPane();
        this.listCurrentTransformer = new JList();
        this.buConfigFitnessTransformer = JButtonFactory.newButton();
        this.buRemoveTransformer = JButtonFactory.newButton();
        this.jPanel1 = new JPanel();
        this.buHelp = JButtonFactory.newButton();
        this.buClose = JButtonFactory.newButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("Fitness Transformer");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FitnessTransformerDialog.this.closeDialog(evt);
            }
        });
        this.jPanel10.setLayout(new GridBagLayout());
        this.jPanel10.setBorder(new TitledBorder("Fitness Transformer Selection"));
        this.jPanel12.setLayout(new GridBagLayout());
        this.jPanel12.setBorder(new TitledBorder("Available Fitness Transformers"));
        this.jPanel12.setMinimumSize(new Dimension(220, 0));
        this.jPanel12.setPreferredSize(new Dimension(220, 0));
        this.listAvailableTransformers.setSelectionMode(0);
        this.listAvailableTransformers.setEnabled(false);
        this.listAvailableTransformers.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FitnessTransformerDialog.this.listAvailableTransformerValueChanged(evt);
            }
        });
        this.listAvailableTransformers.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitnessTransformerDialog.this.listAvailableTransformerMouseClicked(evt);
            }
        });
        this.jScrollPane11.setViewportView(this.listAvailableTransformers);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel12.add((Component)this.jScrollPane11, gridBagConstraints);
        this.jScrollPane12.setMinimumSize(new Dimension(0, 80));
        this.jScrollPane12.setPreferredSize(new Dimension(0, 80));
        this.taDescrFitnessTransformer.setEditable(false);
        this.taDescrFitnessTransformer.setLineWrap(true);
        this.taDescrFitnessTransformer.setText("<no fitness transformer selected>");
        this.taDescrFitnessTransformer.setWrapStyleWord(true);
        this.jScrollPane12.setViewportView(this.taDescrFitnessTransformer);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel12.add((Component)this.jScrollPane12, gridBagConstraints);
        this.buAddTransformer.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Forward16.gif")));
        this.buAddTransformer.setMnemonic('a');
        this.buAddTransformer.setText("Add");
        this.buAddTransformer.setEnabled(false);
        this.buAddTransformer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitnessTransformerDialog.this.buAddTransformerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel12.add((Component)this.buAddTransformer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel10.add((Component)this.jPanel12, gridBagConstraints);
        this.jPanel13.setLayout(new GridBagLayout());
        this.jPanel13.setBorder(new TitledBorder("Current Fitness Transformers"));
        this.listCurrentTransformer.setSelectionMode(0);
        this.listCurrentTransformer.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FitnessTransformerDialog.this.listCurrentTransformerValueChanged(evt);
            }
        });
        this.listCurrentTransformer.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitnessTransformerDialog.this.listCurrentTransformerMouseClicked(evt);
            }
        });
        this.jScrollPane17.setViewportView(this.listCurrentTransformer);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel13.add((Component)this.jScrollPane17, gridBagConstraints);
        this.buConfigFitnessTransformer.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.buConfigFitnessTransformer.setMnemonic('o');
        this.buConfigFitnessTransformer.setText("Configure...");
        this.buConfigFitnessTransformer.setEnabled(false);
        this.buConfigFitnessTransformer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitnessTransformerDialog.this.buConfigFitnessTransformerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel13.add((Component)this.buConfigFitnessTransformer, gridBagConstraints);
        this.buRemoveTransformer.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Delete16.gif")));
        this.buRemoveTransformer.setMnemonic('r');
        this.buRemoveTransformer.setText("Remove");
        this.buRemoveTransformer.setEnabled(false);
        this.buRemoveTransformer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitnessTransformerDialog.this.buRemoveTransformerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel13.add((Component)this.buRemoveTransformer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel10.add((Component)this.jPanel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.jPanel10, gridBagConstraints);
        this.buHelp.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Help16.gif")));
        this.buHelp.setMnemonic('h');
        this.buHelp.setText("Help");
        this.buHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitnessTransformerDialog.this.buHelpActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.buHelp);
        this.buClose.setMnemonic('c');
        this.buClose.setText("Close");
        this.buClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitnessTransformerDialog.this.buCloseActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.buClose);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void buHelpActionPerformed(ActionEvent evt) {
        HelpDialog help = new HelpDialog((Dialog)this, "Fitness transformers provide additional functionality to your fitness function. They are applied to your fitness function and transform the computed fitness values. You may add multiple transformers which will be applied in the specified order in the list.");
        help.setVisible(true);
    }

    private void buCloseActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void buRemoveTransformerActionPerformed(ActionEvent evt) {
        if (!this.listCurrentTransformer.isSelectionEmpty()) {
            int i = this.listCurrentTransformer.getSelectedIndex();
            DefaultListModel model = (DefaultListModel)this.listCurrentTransformer.getModel();
            model.remove(i);
            this.currentFitnessTransformers.remove(i);
        }
    }

    private void buConfigFitnessTransformerActionPerformed(ActionEvent evt) {
        int i;
        FitnessTransformer ft;
        if (!this.listCurrentTransformer.isSelectionEmpty() && (ft = (FitnessTransformer)this.currentFitnessTransformers.get(i = this.listCurrentTransformer.getSelectedIndex())) instanceof Configurable) {
            DefaultListModel model = (DefaultListModel)this.listCurrentTransformer.getModel();
            String s = Util.configureModule(this, ft, this.schedule);
            if (s != null) {
                model.set(i, new String(String.valueOf(ft.getName()) + " (" + s + ")"));
            }
        }
    }

    private void listCurrentTransformerMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.buConfigFitnessTransformerActionPerformed(null);
        }
    }

    private void listCurrentTransformerValueChanged(ListSelectionEvent evt) {
        if (this.listCurrentTransformer.isSelectionEmpty()) {
            this.buRemoveTransformer.setEnabled(false);
            this.buConfigFitnessTransformer.setEnabled(false);
        } else {
            this.buRemoveTransformer.setEnabled(true);
            FitnessTransformer ft = (FitnessTransformer)this.currentFitnessTransformers.get(this.listCurrentTransformer.getSelectedIndex());
            this.buConfigFitnessTransformer.setEnabled(ft instanceof Configurable);
        }
    }

    private void buAddTransformerActionPerformed(ActionEvent evt) {
        if (!this.listAvailableTransformers.isSelectionEmpty()) {
            FitnessTransformer selectedTransformer = (FitnessTransformer)this.listAvailableTransformers.getSelectedValue();
            FitnessTransformer ft = null;
            try {
                ft = (FitnessTransformer)this.moduleCollector.newModule(selectedTransformer.getClass(), new Object[]{this.schedule});
            }
            catch (UnsupportedEnvironmentException e) {
                throw new RuntimeException("Fitness Transformer " + selectedTransformer.getClass() + " is not supported even though checked before.");
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Fitness Transformer " + selectedTransformer.getClass() + " could not be instantiated even though checked before.");
            }
            ft.createEvents();
            this.currentFitnessTransformers.add(ft);
            String name = ft.getName();
            if (ft instanceof Configurable) {
                Configurable confobj = (Configurable)((Object)ft);
                String confstr = confobj.getConfiguration().getDescription();
                name = String.valueOf(name) + " (" + confstr + ")";
            }
            DefaultListModel model = (DefaultListModel)this.listCurrentTransformer.getModel();
            model.addElement(name);
            this.listCurrentTransformer.setSelectedValue(name, true);
        }
    }

    private void listAvailableTransformerMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.buAddTransformerActionPerformed(null);
        }
    }

    private void listAvailableTransformerValueChanged(ListSelectionEvent evt) {
        if (this.listAvailableTransformers.isSelectionEmpty()) {
            Util.displayText(this.taDescrFitnessTransformer, "<no fitness transformer selected>");
        } else {
            int i = this.listAvailableTransformers.getSelectedIndex();
            Util.displayText(this.taDescrFitnessTransformer, this.fitnessTransformers[i].getDescription());
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

