/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.branchandbound.tsp.demo;

import edu.ucsb.cs.jicos.applications.branchandbound.tsp.demo.MandelbrotSet;
import edu.ucsb.cs.jicos.applications.utilities.graph.GraphEuclidean;
import edu.ucsb.cs.jicos.services.Client2Hsp;
import edu.ucsb.cs.jicos.services.Environment;
import edu.ucsb.cs.jicos.services.HspAgent;
import java.util.Observable;

final class Model
extends Observable {
    GraphEuclidean graph;
    static final int MOVE = 0;
    static final int ZOOM = 1;
    static final int UNZOOM = 2;
    int operation = 0;
    boolean sequential = true;
    MandelbrotSet mandelbrotSet;
    Client2Hsp hsp;

    Model(int n) {
        this.graph = new GraphEuclidean(n, n, 10);
    }

    GraphEuclidean getGraph() {
        return this.graph;
    }

    void extend() {
    }

    MandelbrotSet getMandelbrotSet() {
        return this.mandelbrotSet;
    }

    void goBack() {
        this.setChanged();
        this.notifyObservers();
        this.clearChanged();
    }

    void goForward() {
        this.view();
    }

    void janetLogin(String string) {
        HspAgent hspAgent = new HspAgent(string);
        this.hsp = hspAgent.getClient2Hsp();
        Environment environment = new Environment(null, null);
        try {
            this.hsp.login(environment);
        }
        catch (Exception exception) {
            System.exit(1);
        }
    }

    void janetLogout() {
        try {
            this.hsp.logout();
        }
        catch (Exception exception) {
            System.exit(1);
        }
    }

    void notifyView() {
        this.setChanged();
        this.notifyObservers();
        this.clearChanged();
    }

    void recenter(int n, int n2) {
        this.mandelbrotSet.recenter(n, n2);
        this.view();
    }

    void reset() {
        this.mandelbrotSet.reset();
        this.operation = 0;
        this.view();
    }

    void setColorBits(int n) {
        this.mandelbrotSet.setColorBits(n);
        this.notifyView();
    }

    void setOperation(int n) {
        this.operation = n;
    }

    void setResolution(int n) {
        this.mandelbrotSet.setResolution(n);
        this.notifyView();
    }

    void view() {
        this.notifyView();
    }
}

