/*
 * Decompiled with CFR 0.152.
 */
package freak.module.stoppingcriterion;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.GenerationEvent;
import freak.core.event.GenerationEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.stoppingcriterion.AbstractStoppingCriterion;

public class GenerationCount
extends AbstractStoppingCriterion
implements Configurable,
GenerationEventListener {
    private int count = 10000;

    public GenerationCount(Schedule schedule) {
        super(schedule);
    }

    public String getName() {
        return "Generation Count";
    }

    public String getDescription() {
        return "Stops a run after the specified number of generations.";
    }

    public void setPropertyCount(Integer count) {
        if (count > 0) {
            this.count = count;
        }
    }

    public Integer getPropertyCount() {
        return new Integer(this.count);
    }

    public String getShortDescriptionForCount() {
        return "Generations";
    }

    public String getLongDescriptionForCount() {
        return "The number of generations after which the run is to be stopped.";
    }

    public void generation(GenerationEvent evt) {
        if (evt.getNumber() >= this.count) {
            this.stopRun();
        }
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, GenerationEvent.class, this.schedule);
    }
}

