/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.permutation;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.Permutation;
import freak.module.searchspace.PermutationGenotype;

public class Sort_EXC
extends AbstractStaticSingleObjectiveFitnessFunction {
    public Sort_EXC(Schedule schedule) {
        super(schedule);
    }

    protected double evaluate(Genotype genotype) {
        return this.calculateEXC((PermutationGenotype)genotype);
    }

    public String getName() {
        return "Sorting with measure EXC";
    }

    public String getDescription() {
        return "The sorting problem can be viewed as an optimization problem: the sortedness of a sequence has to be maximized. We assume a_1 < a_2 < ... < a_n, so the optimal permutation is the identity. \nThe measure of sortedness used by this fitness function is EXC.\nEXC(pi) denotes the minimal number of exchanges (of pairs pi(i) and pi(j)) necessary to sort the sequence.\nThis leads to a minimization problem. In order to get a maximization problem, the fitness actually returned by this function is -EXC(pi).";
    }

    private int calculateEXC(PermutationGenotype gt) {
        int[] a = gt.getIntArray();
        int cycles = 0;
        boolean[] visited = new boolean[a.length];
        int i = 0;
        while (i < a.length) {
            visited[i] = false;
            ++i;
        }
        i = 0;
        while (i < a.length) {
            if (visited[i]) {
                ++i;
                continue;
            }
            ++cycles;
            int j = i;
            while (!visited[j]) {
                visited[j] = true;
                j = a[j] - 1;
            }
        }
        return -(a.length - cycles);
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int n = ((Permutation)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int[] a = new int[n];
        int i = 0;
        while (i < n) {
            a[i] = i;
            ++i;
        }
        return new PermutationGenotype(a);
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return -(((Permutation)this.getSchedule().getPhenotypeSearchSpace()).getDimension() - 1);
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return 0.0;
    }
}

