% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorGradient.R
\name{colorGradient}
\alias{colorGradient}
\title{Color Gradient Generator}
\usage{
colorGradient(x, colors = heat.colors(10), colsteps = 100, na.rm = TRUE, ...)
}
\arguments{
\item{x}{numeric vector}

\item{colors}{values recognizable by R as colors - text, hexadecimal, numbers, etc. (default = \code{grDevices::heat.colors(10)}).}

\item{colsteps}{numeric value, number of unique colors to include in gradient}

\item{na.rm}{logical value (default = \code{TRUE}) indicating whether to exclude \code{NA} values in \code{x}}

\item{...}{additional arguments passed to \code{grDevices::colorRamp}}
}
\value{
character vector
}
\description{
Generate a gradient of hexadecimal colors from a numeric vector
}
\details{
\code{colorGradient} generates a color gradient based on a numeric input \code{x}.
The original version (named 'color.gradient') was written by David Hoop in a 2016 stack.overflow response to question (online). The function was
modified slightly for adaptability of inputs. Note that the full color gradient is used if possible,
which can exaggerate small differences in \code{x}. This function is applied by \code{optimFPM} when generating color-based
optimization matrix graphics (i.e., when optimizing both \code{alpha} and \code{FN_crit}).
}
\examples{
x <- rnorm(n = 100)
cols <- colorGradient(x = x, colors = c("red", "white", "blue"))
plot(x, col = cols)
}
\seealso{
optimFPM, heat.colors, colorRamp
}
