% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.resi}
\alias{plot.resi}
\title{Plotting RESI Estimates and CIs}
\usage{
\method{plot}{resi}(
  x,
  alpha = NULL,
  ycex.axis = NULL,
  yaxis.args = list(),
  automar = TRUE,
  ...
)
}
\arguments{
\item{x}{Object of `resi`, `summary_resi`, or `anova_resi` class}

\item{alpha}{Numeric, desired alpha level for confidence intervals}

\item{ycex.axis}{Numeric, scale specifically for the variable name labels}

\item{yaxis.args}{List, other arguments to be passed to \code{\link{axis}} for the y-axis}

\item{automar}{Logical, whether to automatically adjust the plotting margins to accommodate variable names. Default = `TRUE`}

\item{...}{Other graphical parameters passed to \code{\link{plot}} and \code{\link{lines}}}
}
\value{
Returns a plot of RESI point estimates
}
\description{
This function uses base graphics to plot robust effect size (RESI) estimates and confidence intervals
from `resi`, `summary_resi`, and `anova_resi` objects.
}
\details{
This function creates a forest-like plot with RESI estimates for each variable or factor.
The size of the left margin will be automatically adjusted (and returned to original after plotting)
unless `automar = FALSE`. Additional graphics parameters will be passed to the main
plot function, the confidence intervals. Arguments specifically for the y-axis (variable names)
can be specified using `yaxis.args`. To manually adjust the size of the y-axis labels without
affecting the x-axis, the user can specify a value for `ycex.axis`.
}
\examples{
# create a resi object
resi_obj <- resi(lm(charges ~ region * age + bmi + sex, data = RESI::insurance),
nboot = 10)

# plot coefficients table, changing size of labels for both axes in the usual way
plot(resi_obj, cex.alpha = 0.7)

# plot ANOVA table, changing the size of just the y-axis
plot(resi_obj, ycex.alpha = 0.8)
}
