#' @title Get Criteo Account Information
#' 
#' @description This function returns the Criteo Account Information.
#' 
#' @param authToken Authentication token generated by \code{\link{doCriteoAuth}}
#' @param appToken Application Token
#' 
#' @export
#' 
#' @return Account Information
getCriteoAccount <- function(authToken, appToken){
  
  body = paste('<?xml version="1.0" encoding="utf-8"?>
               <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
               <soap:Header>
               <apiHeader xmlns="https://advertising.criteo.com/API/v201010">
               <authToken>', authToken ,'</authToken>
               <appToken>', appToken ,'</appToken>
               <clientVersion>string</clientVersion>
               </apiHeader>
               </soap:Header>
               <soap:Body>
               <getAccount xmlns="https://advertising.criteo.com/API/v201010" />
               </soap:Body>
               </soap:Envelope>',sep="")
          
          headerFields = c(Accept = "text/xml",
                            Accept = "multipart/*",
                            'Content-Type' = "text/xml; charset=utf-8",
                            SOAPAction = "https://advertising.criteo.com/API/v201010/getAccount")
          
          h = RCurl::basicTextGatherer()
          
          RCurl::curlPerform(url = "https://advertising.criteo.com/API/v201010/AdvertiserService.asmx",
                      httpheader = headerFields,
                      postfields = body,
                      writefunction = h$update
                      )
          
          xy <- sub('xmlns="https://advertising.criteo.com/API/v201010"','',h$value())
          doc <- XML::xmlRoot(XML::xmlTreeParse(xy, useInternalNodes = TRUE))
          #xmlValue <- NULL
          data <- data.frame(Name=XML::xpathSApply(doc, "//advertiserName", XML::xmlValue),
                             Email=XML::xpathSApply(doc, "//email", XML::xmlValue),
                             Currency=XML::xpathSApply(doc, "//currency", XML::xmlValue),
                             TimeZone=XML::xpathSApply(doc, "//timezone", XML::xmlValue),
                             Country=XML::xpathSApply(doc, "//country", XML::xmlValue))
          data
}