% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{rotation}
\alias{rotation}
\alias{translation}
\alias{scaling}
\alias{reflection}
\title{Affine planar transformations matrix}
\source{
Richter-Gebert, Jürgen (2011). 
\emph{Perspectives on Projective Geometry - A Guided Tour Through Real
and Complex Geometry}, Springer, Berlin, ISBN: 978-3-642-17285-4
}
\usage{
rotation(theta, pt = NULL)

translation(v)

scaling(s)

reflection(alpha)
}
\arguments{
\item{theta}{the angle of the rotation (in radian).}

\item{pt}{the homogeneous coordinates of the rotation center (optional).}

\item{v}{the \eqn{(2 \times 1)} translation vector in direction \eqn{x} and \eqn{y}.}

\item{s}{the \eqn{(2 \times 1)} scaling vector in direction \eqn{x} and \eqn{y}.}

\item{alpha}{the angle made by the line of reflection (in radian).}
}
\value{
A \eqn{(3 \times 3)} affine transformation matrix.
}
\description{
\eqn{(3 \times 3)} affine planar transformation matrix corresponding 
to reflection, rotation, scaling and translation in projective geometry. 
To transform a point \eqn{p} multiply the transformation matrix \eqn{A} with 
the homogeneous coordinates \eqn{(x,y,z)} of \eqn{p} 
(e.g. \eqn{p_{transformed} = Ap}).
}
\examples{
p1 <- c(2,5,1)  # homogeneous coordinate

# rotation
r_p1 <- rotation(4.5) \%*\% p1

# rotation centered in (3,1)
rt_p1 <- rotation(4.5, pt=c(3,1,1)) \%*\% p1

# translation
t_p1 <- translation(c(2,-4)) \%*\% p1

# scaling
s_p1 <- scaling(c(-3,1)) \%*\% p1

# plot
plot(t(p1),xlab="x",ylab="y", xlim=c(-5,5),ylim=c(-5,5),asp=1)
abline(v=0,h=0, col="grey",lty=1)
abline(v=3,h=1, col="grey",lty=3)
points(3,1,pch=4)
points(t(r_p1),col="red",pch=20)
points(t(rt_p1),col="blue",pch=20)
points(t(t_p1),col="green",pch=20)
points(t(s_p1),col="black",pch=20)
}
