% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.functions.r
\name{wtd.cor}
\alias{wtd.cor}
\title{Calculates Correlation Coefficient Between Two Numeric Variables
Makes use of the wtd.cor function, part of the weights package.}
\usage{
wtd.cor(x1, x2, w = NULL, data, digits = 3, stats = FALSE, ...)
}
\arguments{
\item{x1}{A variable (must be numeric), should be in dataset$var form unless dataset specified in optional data argument.}

\item{x2}{Another variable, different than x1 (must be numeric), should be in dataset$var form unless dataset specified in optional data argument.}

\item{w}{(Optional) Sampling weights of variable, must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{data}{(Optional) Name of dataset that contains x (and w) variable.}

\item{digits}{(Optional) Number of decimal places reported in result (defaults: 3).}

\item{stats}{(Optional) Do you want inferential statistics for correlation coefficient? (default: FALSE)}

\item{...}{(Optional) Additional arguments passed to weights::wtd.cor function.}
}
\value{
Returns the coefficient of correlation between x1 and x2 variables, a numeric value.
}
\description{
Given two numeric variables, wtd.cor reports correlation coefficient, works with sampling weights. 
The \code{\link[weights]{wtd.cor}} function is imported from the weights package. See \code{\link[weights]{wtd.cor}} documentation for details.
}
\examples{
   library(RCPA3)
   
   wtd.cor(x1=nes$ft.rep, x2=nes$ft.pence.pre, w=nes$wt)
   wtd.cor(x1=ft.dem, x2=ft.harris.pre, w=wt, data=nes)
}
\keyword{internal}
