% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway-analysis.R
\name{runPathwayAnalysis}
\alias{runPathwayAnalysis}
\title{Pathway Enrichment Analysis}
\usage{
runPathwayAnalysis(
  summarizedExperiment,
  network,
  method = c("spia", "cepaORA", "cepaGSA"),
  SPIAArgs = list(all = NULL, nB = 2000, verbose = TRUE, beta = NULL, combine = "fisher",
    pThreshold = 0.05),
  CePaORAArgs = list(bk = NULL, cen = list("equal.weight", "in.degree", "out.degree",
    "betweenness", "in.reach", "out.reach"), cen.name = list("equal.weight", "in.degree",
    "out.degree", "betweenness", "in.reach", "out.reach"), iter = 1000, pThreshold =
    0.05),
  CePaGSAArgs = list(cen = list("equal.weight", "in.degree", "out.degree", "betweenness",
    "in.reach", "out.reach"), cen.name = list("equal.weight", "in.degree", "out.degree",
    "betweenness", "in.reach", "out.reach"), nlevel = "tvalue_abs", plevel = "mean", iter
    = 1000)
)
}
\arguments{
\item{summarizedExperiment}{The generated SummarizedExpriment object from DE analysis result.}

\item{network}{The pathways network object.}

\item{method}{The pathway analsyis method, including SPIA, cepaORA, and cepaGSA.}

\item{SPIAArgs}{A list of other passed arguments to spia. See spia function.}

\item{CePaORAArgs}{A list of other passed arguments to CePaORA. See CePa function.}

\item{CePaGSAArgs}{A list of other passed arguments to CePaGSA. See CePa function.}
}
\value{
A dataframe of pathway analysis result
}
\description{
This function performs patwhay analysis using SPIA, CePaORA, and CePaGSA methods.
}
\examples{
\donttest{
library(RCPA)
RNASeqDEExperiment <- loadData("RNASeqDEExperiment")
spiaNetwork <- loadData("spiaNetwork")
cepaNetwork <- loadData("cepaNetwork")

spiaResult <- runPathwayAnalysis(RNASeqDEExperiment, spiaNetwork, method = "spia")
cepaORAResult <- runPathwayAnalysis(RNASeqDEExperiment, cepaNetwork, method = "cepaORA")
cepaGSAResult <- runPathwayAnalysis(RNASeqDEExperiment, cepaNetwork, method = "cepaGSA")
}
}
