% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBMRB.R
\name{convert_cs_to_c13hsqc}
\alias{convert_cs_to_c13hsqc}
\title{Reformats chemical shift dataframe for easy plotting}
\usage{
convert_cs_to_c13hsqc(csdf)
}
\arguments{
\item{csdf}{chemical shift data frame from \link{fetch_entry_chemical_shifts}}
}
\value{
R data frame that contains proton and carbon chemical shifts in two columns for each residue
}
\description{
Reformats the output dataframe from \link{fetch_entry_chemical_shifts} into a simple dataframe that contains proton and carbon chemical shifts in two columns.
This will be helpful to plot 1H-13C HSQC(Hetronuclear Single Quantum Coherence) spectrum
}
\examples{
df<-fetch_entry_chemical_shifts(15060)
# Downloads data from BMRB
hsqc<-convert_cs_to_c13hsqc(df)
# Reformats for easy plotting
}
\seealso{
\code{\link{convert_cs_to_n15hsqc}} and \code{\link{convert_cs_to_tocsy}}
}
