% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsa.bench.r
\name{lsa.bench}
\alias{lsa.bench}
\title{Compute percentages of respondents reaching or surpassing certain ability cut-off scores}
\usage{
lsa.bench(
  data.file,
  data.object,
  split.vars,
  PV.root.bench,
  bench.vals,
  bench.type,
  pcts.within = FALSE,
  bckg.var,
  weight.var,
  include.missing = FALSE,
  shortcut = FALSE,
  output.file,
  open.output = TRUE
)
}
\arguments{
\item{data.file}{The file containing \code{lsa.data} object. Either this or \code{data.object}
shall be specified, but not both. See details.}

\item{data.object}{The object in the memory containing \code{lsa.data} object. Either this
or \code{data.file} shall be specified, but not both. See details.}

\item{split.vars}{Categorical variable(s) to split the results by. If no split variables are
provided, the results will be for the overall countries' populations. If
one or more variables are provided, the results will be split by all but
the last variable and the percentages of respondents will be computed by
the unique values of the last splitting variable.}

\item{PV.root.bench}{The root name(s) for the set(s) of plausible values which will be used
to compute the percentages of respondents reaching or surpassing certain
cut-off score. See details.}

\item{bench.vals}{A vector of integers representing the cut-off scores. See details.}

\item{bench.type}{A character string representing how the percentages of respondents shall
be computed. See details.}

\item{pcts.within}{Logical value specifying if the percentages shall be computed within the
groups defined by the \code{split.vars} (\code{TRUE}) or not (\code{FALSE},
default). See details.}

\item{bckg.var}{Name of continuous background or contextual variable to compute the mean
for. The results will be computed by all groups specified by the splitting
variables and per performance group. See details.}

\item{weight.var}{The name of the variable containing the weights. If no name of a weight
variable is provide, the function will automatically select the default
weight variable for the provided data, depending on the respondent type.}

\item{include.missing}{Logical, shall the missing values of the splitting variables be included
as categories to split by and all statistics produced for them? The
default (\code{FALSE}) takes all cases on the splitting variables
without missing values before computing any statistics. See details.}

\item{shortcut}{Logical, shall the "shortcut" method for IEA TIMSS, TIMSS Advanced,
TIMSS Numeracy, eTIMSS, PIRLS, ePIRLS, PIRLS Literacy and RLII be applied?
The default (\code{FALSE}) applies the "full" design when computing the
variance components and the standard errors of the estimates.}

\item{output.file}{Full path to the output file including the file name. If omitted, a file
with a default file name "Analysis.xlsx" will be written to the working
directory (\code{getwd()}).}

\item{open.output}{Logical, shall the output be open after it has been written? The default
(\code{TRUE}) opens the output in the default spreadsheet program
installed on the computer.}
}
\value{
A MS Excel (\code{.xlsx}) file (which can be opened in any spreadsheet program), as specified with the full path in the \code{output.file}. If the argument is missing, an Excel file with the generic file name "Analysis.xlsx" will be saved in the working directory (\code{getwd()}). The workbook contains three spreadsheets. The first one ("Estimates") contains a table with the results by country and the final part of the table contains averaged results from all countries' statistics. The following columns can be found in the table, depending on the specification of the analysis:

\itemize{
\item \verb{<}Country ID\verb{>} - a column containing the names of the countries in the file for which statistics are computed. The exact column header will depend on the country identifier used in the particular study.
\item \verb{<}Split variable 1\verb{>}, \verb{<}Split variable 2\verb{>}... - columns containing the categories by which the statistics were split by. The exact names will depend on the variables in \code{split.vars}.
\item n_Cases - the number of cases reaching or surpassing each of the benchmarks using a set of PVs. Please note that these may not be whole numbers because they are computed using each PV and then averaged.
\item Sum_\verb{<}Weight variable\verb{>} - the estimated population number of elements per group after applying the weights. The actual name of the weight variable will depend on the weight variable used in the analysis.
\item Sum_\verb{<}Weight variable\verb{>}\verb{_}SE - the standard error of the the estimated population number of elements per group. The actual name of the weight variable will depend on the weight variable used in the analysis.
\item Performance_Group - the labels for the performance groups defined by the \code{bench.vals}.
\item Percentages_\verb{<}PVs' root name\verb{>} - the percentages of respondents (population estimates) reaching or surpassing each cut-off score (in case of \code{bench.type = "discrete"}) or the the percentages of respondents (population estimates) at or above each cut-off value (in case of \code{bench.type = "cumulative"}) per groups defined by the splitting variables in \code{split.vars}.
\item Percentages_\verb{<}PVs' root name\verb{>}\verb{_}SE - the standard errors of the percentages from above.
\item Mean_\verb{<}Background variable\verb{>} - the average of the continuous \verb{<}Background variable\verb{>} specified in \code{bckg.var}.
\item Mean_\verb{<}Background variable\verb{>}\verb{_}SE - the standard error of the average of the continuous \verb{<}Background variable\verb{>} specified in \code{bckg.var}.
\item Variance_\verb{<}Background variable\verb{>} - the variance for the continuous \verb{<}Background variable\verb{>} specified in \code{bckg.var}.
\item Variance_\verb{<}Background variable\verb{>}\verb{_}SE - the error of the variance for the continuous \verb{<}Background variable\verb{>} specified in \code{bckg.var}.
\item SD_\verb{<}Background variable\verb{>} - the standard deviation for the continuous \verb{<}Background variable\verb{>} specified in \code{bckg.vars}.
\item SD_\verb{<}Background variable\verb{>}\verb{_}SE - the error of the standard deviation for the continuous \verb{<}Background variable\verb{>} specified in \code{bckg.avg.var}.
\item Percent_Missings_\verb{<}Background variable\verb{>} - the percentage of missing values for the \verb{<}Background variable\verb{>} specified in \code{bckg.var}.
}

The second sheet contains some additional information related to the analysis per country in columns:
\itemize{
\item DATA - used \code{data.file} or \code{data.object}.
\item STUDY - which study the data comes from.
\item CYCLE - which cycle of the study the data comes from.
\item WEIGHT - which weight variable was used.
\item DESIGN - which resampling technique was used (JRR or BRR).
\item SHORTCUT - logical, whether the shortcut method was used.
\item NREPS - how many replication weights were used.
\item ANALYSIS_DATE - on which date the analysis was performed.
\item START_TIME - at what time the analysis started.
\item END_TIME - at what time the analysis finished.
\item DURATION - how long the analysis took in hours, minutes, seconds and milliseconds.
}

The third sheet contains the call to the function with values for all parameters as it was executed. This is useful if the analysis needs to be replicated later.
}
\description{
\code{lsa.pcts.means} computes percentages of respondents reaching or surpassing certain ability cut-off scores (benchmarks/performance levels). The cut-off scores are points in the distributions of PVs defined differently in different studies and, sometimes, in different study cycles. The percentages can also be computed as cumulative percentages. There is an option to compute an average of continuous contextual/background variable.
}
\details{
Either \code{data.file} or \code{data.object} shall be provided as source of data. If both of them are provided, the function will stop with an error message.

The function computes percentages of respondents which reach or surpass certain cut-off scores (benchmarks/performance levels). These percentages are computed using a set of PVs, specified in the \code{PV.root.bench}. Only one set of PVs can be added to \code{PV.root.bench} at a time. All studies (except CivED, TEDS-M, SITES, TALIS and TALIS Starting Strong Survey) have a set of PVs per content domain (e.g. in TIMSS five for overall mathematics, five for algebra, five for geometry, etc.) and cognitive domain (i.e. knowing, applying and reasoning). In some studies (say TIMSS and PIRLS) the names of the PVs in a set always start with character string and end with sequential number of the PV. For example, the names of the set of PVs for overall mathematics in TIMSS are BSMMAT01, BSMMAT02, BSMMAT03, BSMMAT04 and BSMMAT05. The root of the PVs for this set to be added to \code{PV.root.avg} will be "BSMMAT". The function will automatically find all the variables in this set of PVs and include them in the analysis. In other studies like OECD PISA and IEA ICCS and ICILS the sequential number of each PV is included in the middle of the name. For example, in ICCS the names of the set of PVs are PV1CIV, PV2CIV, PV3CIV, PV4CIV and PV5CIV. The root PV name has to be specified in \code{PV.root.bench} as "PV#CIV".

Multiple splitting variables can be added to the \code{split.vars}, the function will compute the percentages of respondents reaching or surpassing the cut-off scores for all formed groups and their means on the continuous variables. If no splitting variables are added, the results will be only by country.

If a continuous contextual/background variable is provided to the \code{bckg.var}, the average for that variable will be computed for each group formed by the splitting variables and the performance groups. Only one contextual/background variable can be added in the analysis. This argument is ignored when \code{bench.type = "cumulative"}.

The cut-off scores are provided as vector of integers (e.g. \code{c(475, 500)}) to the \code{bench.vals}. If no cut-off scores are provided, the function will automatically choose all benchmark values for the corresponding study and, in some cases for the data from the specific cycle. The latter applies to ICCS and PISA where the proficiency levels differ from one cycle to another.

The \code{bench.type} argument has two different options: \code{"discrete"} (default) and \code{"cumulative"}. Using the former will compute the percentages of respondents within the boundaries specified by the cut-off scores in \code{bench.vals}. Using the latter, the function will compute the percentages of respondents at or above the cut-off points in the \code{bench.vals}.

If the \code{pcts.within} if \code{FALSE} (default), the function will compute the percentages of respondents reaching or surpassing each of the cut-off scores defined by \code{bench.vals}. In this case the percentages of all respondents across the performance levels will add to 100 in each group defined by the splitting variables. On the contrary, if \code{pcts.within = TRUE}, the function will compute the percentages of respondents at each of the performance levels across groups defined by the splitting variables. Then the sum of percentages within a specific performance level will sum up to 100 across the groups defined by the splitting variables. For example, we can compute what is the ratio (i.e. percentages) of female and male students performing between 475 and 550 points in PIRLS -- say 55 of all students performing at this level are female and 45 are male. If no split variables are provided, the percentages will be 100 for each performance level within a country. The argument is ignored if \code{bench.type = "cumulative"}.

If no variables are specified for \code{bckg.vars}, the output will contain only percentages of cases in groups specified by the splitting variables and the cut-off scores.

If \code{include.missing = FALSE} (default), all cases with missing values on the splitting variables will be removed and only cases with valid values will be retained in the statistics. Note that the data from the studies can be exported in two different ways: (1) setting all user-defined missing values to \code{NA}; and (2) importing all user-defined missing values as valid ones and adding their codes in an additional attribute to each variable. If the \code{include.missing} is set to \code{FALSE} (default) and the data used is exported using option (2), the output will remove all values from the variable matching the values in its \code{missings} attribute. Otherwise, it will include them as valid values and compute statistics for them.

The \code{shortcut} argument is valid only for TIMSS, TIMSS Advanced, TIMSS Numeracy, PIRLS, ePIRLS, PIRLS Literacy and RLII. Previously, in computing the standard errors, these studies were using 75 replicates because one of the schools in the 75 JK zones had its weights doubled and the other one has been taken out. Since TIMSS 2015 and PIRLS 2016 the studies use 150 replicates and in each JK zone once a school has its weights doubled and once taken out, i.e. the computations are done twice for each zone. For more details see Foy & LaRoche (2016) and Foy & LaRoche (2017). If replication of the tables and figures is needed, the \code{shortcut} argument has to be changed to \code{TRUE}.
}
\examples{
# Compute percentages of female and male students reaching or surpassing the "Intermediate"
# and "High" benchamrks in TIMSS 2015 grade 8 mathematics using data file, omit missing from
# the splitting variable (female and male as answered by the students), without shortcut, and
# open the output after the computations are done
\dontrun{
lsa.bench(data.file = "C:/Data/TIMSS_2015_G8_Student_Miss_to_NA.RData", split.vars = "BSBG01",
include.missing = FALSE, PV.root.bench = "BSMMAT", bench.vals = c(475, 550),
output.file = "C:/temp/test.xlsx", open.output = TRUE)
}

# Repeat the analysis from above, using an object loaded in the memory, the student senate
# weight and compute the cumulative percentage, adding student feeling safe at school as a
# second splitting variable, using the shortcut method and including the missing values of
# the splitting variables
\dontrun{
lsa.bench(data.object = T15_G8_student_data, split.vars = c("BSBG01", "BSBG15B"),
PV.root.bench = "BSMMAT", bench.vals = c(475, 550), weight.var = "SENWGT",
include.missing = TRUE, shortcut = TRUE, output.file = "C:/temp/test.xlsx",
open.output = TRUE)
}

# Compute the percentage of students reaching or surpassing the "Level 2" and "Level 3"
# in computer and information lteracy and the average of the complex background scale
# "Use of specialist applications for activities" by student sex and expected further
# level of education using ICILS 2018 data loaded in memory, include the missing values
# in the splitting variables
\dontrun{
lsa.bench(data.object = ICILS_2018_student_data, split.vars = c("S_SEX", "IS2G03"),
PV.root.bench = "PV#CIL", bckg.var = "S_SPECACT", include.missing = TRUE,
output.file = "C:/temp/test.xlsx", open.output = TRUE)
}

# Compute the cumulative percentage of students at or above each of the (default) benchmarks
# of student overall reading achievement scores using PIRLS 2016 student data file, split the
# output by student sex, use the full design, include the missing values of the splitting
# variable (i.e. student sex), and do not open the output after the computations are finished
\dontrun{
lsa.bench(data.file = "C:/Data/PIRLS_2016_Student_Miss_to_NA.RData", split.vars = "ASBG01",
PV.root.bench = "ASRREA", bench.type = "cumulative", include.missing = TRUE,
output.file = "C:/temp/test.xlsx", open.output = FALSE)
}

}
\references{
LaRoche, S., Joncas, M., & Foy, P. (2016). Sample Design in TIMSS 2015. In M. O. Martin, I. V. S. Mullis, & M. Hooper (Eds.), \emph{Methods and Procedures in TIMSS 2015} (pp. 3.1-3.37). Chestnut Hill, MA: TIMSS & PIRLS International Study Center.
LaRoche, S., Joncas, M., & Foy, P. (2017). Sample Design in PIRLS 2016. In M. O. Martin, I. V. S. Mullis, & M. Hooper (Eds.), \emph{Methods and Procedures in PIRLS 2016} (pp. 3.1-3.34). Chestnut Hill, MA: Lynch School of Education, Boston College.
}
\seealso{
\code{\link{lsa.convert.data}}
}
