% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/EM.R
\name{EM_clustering}
\alias{EM_clustering}
\title{Expectation Maximization}
\usage{
EM_clustering(Schrod, contamination, prior_weight = NULL,
  clone_priors = NULL, maxit = 8, nclone_range = 2:5, epsilon = 5 *
  (10^(-3)), ncores = 2)
}
\arguments{
\item{Schrod}{List of dataframes, output of the Schrodinger function or the EM algorithm}

\item{contamination}{The fraction of normal cells in the sample}

\item{prior_weight}{If known a list of priors (fraction of mutations in a clone) to be used in the clustering}

\item{clone_priors}{If known a list of priors (cell prevalence) to be used in the clustering}

\item{maxit}{Maximal number of independant initial condition tests to be tried}

\item{nclone_range}{Number of clusters to look for}

\item{epsilon}{Stop value: maximal admitted value of the difference in cluster position and weights between two optimization steps.}

\item{ncores}{Number of CPUs to be used}
}
\description{
Maximization of the likelihood given a mixture of binomial distributions
}
\keyword{EM}
\keyword{clustering}
\keyword{number}

