% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitdist_ext.R
\name{autoplot.fitdist}
\alias{autoplot.fitdist}
\title{Plot \link[fitdistrplus]{fitdist} Object using \CRANpkg{ggplot2}}
\usage{
\method{autoplot}{fitdist}(
  object,
  data = object[["data"]],
  type = c("density", "distribution"),
  xlim = c(min(data), max(data)),
  obs.col = "black",
  est.col = "red",
  xlab = NULL,
  ylab = object$distname,
  title = NULL,
  caption = NULL,
  ...
)
}
\arguments{
\item{object}{a \link[fitdistrplus]{fitdist} object}

\item{data}{\link[base]{numeric} or \link[base]{integer} vector, actual observations}

\item{type}{\link[base]{character} scalar, whether the 
\code{'density'} (default) or the probability \code{'distribution'} curve should be plotted}

\item{xlim}{\link[base]{numeric} vector of length two, the horizontal limit of the figure.
Default value is the range of the actual observations.}

\item{obs.col}{\link[base]{character} scalar, color to represent the observed values, default black}

\item{est.col}{\link[base]{character} scalar, color to represent the estimated values, default red}

\item{xlab, ylab, title, caption}{\link[base]{character} scalars, see \link[ggplot2]{labs}}

\item{...}{potential parameters of \link[ggplot2]{stat_function}}
}
\value{
\link{autoplot.fitdist} plots \link[fitdistrplus]{fitdist} object using \CRANpkg{ggplot2}.
No value is returned.
}
\description{
Plot \link[fitdistrplus]{fitdist} object using \CRANpkg{ggplot2}.
}
\examples{

library(fitdistrplus)
x1 = rpois(n = 100, lambda = 4)
xfit1 = fitdist(x1, distr = 'pois')
autoplot(xfit1, xlim = c(-3L, 15L))
autoplot(xfit1, type = 'distribution')

x2 = rnorm(n = 1e3L, mean = 2.3, sd = .7)
xfit2 = fitdist(x2, distr = 'norm')
autoplot(xfit2, type = 'density')
autoplot(xfit2, type = 'distribution')

}
