% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NLR.R
\name{NLRTest}
\alias{NLRTest}
\title{Nonparametric likelihood ratio test to test for symmetry.}
\usage{
NLRTest(y, f = NULL, F = NULL, QF = NULL, method = c("smooth",
  "parametric"), nboot = 500)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{f}{This is the reference density function \eqn{f} which is a standard version of a unimodal and symmetric around 0 density.}

\item{F}{This is the cumulative distribution function \eqn{F} of a unimodal and symmetric around 0 reference density function \eqn{f}.}

\item{QF}{This is the quantile function of the reference density \eqn{f}.}

\item{method}{The method to be used for drawing bootstrap samples. The default method is a smooth bootstrap procedure. The density function \eqn{f}, the cumulative distribution function \eqn{F} and the quantile function \eqn{QF} are required for parametric bootstrap procedure. If \eqn{QF} is not given, then the numerical \eqn{QF} will be used.}

\item{nboot}{The number of bootstrap samples desired. The default number is 500.}
}
\value{
The nonparametric likelihood ratio test statistic with bootstrap \eqn{P}-value.
}
\description{
The nonparametric likelihood ratio test to test for symmetry is discussed in Gijbels et al. (2019d).
}
\examples{
\donttest{
# Example 1: Let F be a standard normal cumulative distribution function then
f_N<-function(s){dnorm(s, mean = 0,sd = 1)} # density function of N(0,1)
F_N<-function(s){pnorm(s, mean = 0,sd = 1)} # distribution function of N(0,1)
QF_N<-function(beta){qnorm(beta, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)}
# Example: STRength dataset
my.sample<-c(1.901,2.132,2.203,2.228,2.257,2.350,2.361,2.396,2.397,
             2.445,2.454,2.474,2.518,2.522,2.525,2.532,2.575,2.614,2.616,
             2.618,2.624,2.659,2.675,2.738,2.740,2.856,2.917,2.928,2.937,
             2.937,2.977,2.996,3.030,3.125,3.139,3.145,3.220,3.223,3.235,
            3.243,3.264,3.272,3.294,3.332,3.346,3.377,3.408,3.435,3.493,
             3.501,3.537,3.554,3.562,3.628,3.852,3.871,3.886,3.971,4.024,
             4.027,4.225,4.395,5.020)


NLRTest(my.sample,f=NULL,F=NULL,QF=NULL,method=c("smooth"),nboot=500)
NLRTest(my.sample,f=f_N,F=F_N,QF=QF_N,method=c("parametric"),nboot=500)
NLRTest(my.sample,f=f_N,F=F_N,QF=NULL,method=c("parametric"),nboot=500)
}
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019d). Test of symmetry and a quantile-based asymmetric family of densities, \emph{Manuscript}.
}
}
