% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALoD.R
\name{ALoD}
\alias{ALoD}
\alias{dALoD}
\alias{pALoD}
\alias{qALoD}
\alias{rALoD}
\title{Quantile-based asymmetric logistic distribution}
\usage{
dALoD(y, mu, phi, alpha)

pALoD(q, mu, phi, alpha)

qALoD(beta, mu, phi, alpha)

rALoD(n, mu, phi, alpha)
}
\arguments{
\item{y, q}{These are each a vector of quantiles.}

\item{mu}{This is the location parameter \eqn{\mu}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{beta}{This is a vector of probabilities.}

\item{n}{This is the number of observations, which must be a positive integer that has length 1.}
}
\value{
\code{\link{dALoD}} provides the density, \code{\link{pALoD}} provides the cumulative distribution function, \code{\link{qALoD}} provides the quantile function, and \code{\link{rALoD}} generates a random sample from the quantile-based asymmetric logistic distribution.
The length of the result is determined by \eqn{n} for \code{\link{rALoD}}, and is the maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, cumulative distribution function, quantile function and random sample generation
from the quantile-based asymmetric logistic distribution (ALoD) proposed in Gijbels et al. (2019a).
}
\examples{
# Quantile-based asymmetric logistic distribution (ALoD)
# Density
rnum<-rnorm(100)
dALoD(y=rnum,mu=0,phi=1,alpha=.5)

# Distribution function
pALoD(q=rnum,mu=0,phi=1,alpha=.5)

# Quantile function
beta<-c(0.25,0.5,0.75)
qALoD(beta=beta,mu=0,phi=1,alpha=.5)

# random sample generation
rALoD(n=100,mu=0,phi=1,alpha=.5)

}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, \url{https://doi.org/10.1111/insr.12324}.
}
}
\seealso{
\code{\link{dQBAD}},  \code{\link{pQBAD}},  \code{\link{qQBAD}},  \code{\link{rQBAD}}
}
