% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PowerSDI-package.R
\docType{package}
\name{PowerSDI-package}
\alias{PowerSDI}
\alias{PowerSDI-package}
\title{PowerSDI: Calculate Standardised Drought Indices Using NASA POWER Data}
\description{
A set of functions designed to calculate the standardised precipitation and standardised precipitation evapotranspiration indices using NASA POWER data as described in Blain et al. (2023) \doi{10.2139/ssrn.4442843}. These indices are calculated using a reference data source. The functions verify if the indices' estimates meet the assumption of normality and how well NASA POWER estimates represent real-world data. Indices are calculated in a routine mode. Potential evapotranspiration amounts and the difference between rainfall and potential evapotranspiration are also calculated. The functions adopt a basic time scale that splits each month into four periods. Days 1 to 7, days 8 to 14, days 15 to 21, and days 22 to 28, 29, 30, or 31, where 'TS=4' corresponds to a 1-month length moving window (calculated 4 times per month) and 'TS=48' corresponds to a 12-month length moving window (calculated 4 times per month).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/gabrielblain/PowerSDI}
  \item Report bugs at \url{https://github.com/gabrielblain/PowerSDI/issues}
}

}
\author{
\strong{Maintainer}: Gabriel Constantino Blain \email{gabriel.blain@sp.gov.br} (\href{https://orcid.org/0000-0001-8832-7734}{ORCID})

Authors:
\itemize{
  \item Graciela R. Sobierajski (\href{https://orcid.org/0000-0002-7211-9268}{ORCID})
  \item Leticia L. Martins (\href{https://orcid.org/0000-0002-0299-3005}{ORCID})
  \item Adam H. Sparks \email{adamhsparks@gmail.com} (\href{https://orcid.org/0000-0002-0061-8359}{ORCID})
}

}
\keyword{internal}
