/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openfast.ByteUtil;
import org.openfast.Global;
import org.openfast.ScalarValue;
import org.openfast.StringValue;
import org.openfast.error.FastConstants;
import org.openfast.template.type.codec.TypeCodec;

final class NullableAsciiString
extends TypeCodec {
    private static final long serialVersionUID = 1L;
    private static final byte[] NULLABLE_EMPTY_STRING = new byte[2];
    private static final byte[] ZERO_ENCODING = new byte[3];

    NullableAsciiString() {
    }

    public byte[] encodeValue(ScalarValue value) {
        if (value.isNull()) {
            return TypeCodec.NULL_VALUE_ENCODING;
        }
        String string = ((StringValue)value).value;
        if (string != null && string.length() == 0) {
            return NULLABLE_EMPTY_STRING;
        }
        if (string.startsWith("\u0000")) {
            return ZERO_ENCODING;
        }
        return string.getBytes();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScalarValue decode(InputStream in) {
        ByteArrayOutputStream buffer = Global.getBuffer();
        try {
            int byt;
            do {
                if ((byt = in.read()) < 0) {
                    Global.handleError(FastConstants.END_OF_STREAM, "The end of the input stream has been reached.");
                    return null;
                }
                buffer.write(byt);
            } while ((byt & 0x80) == 0);
        }
        catch (IOException e) {
            Global.handleError(FastConstants.IO_ERROR, "A IO error has been encountered while decoding.", e);
            return null;
        }
        byte[] bytes = buffer.toByteArray();
        int n = bytes.length - 1;
        bytes[n] = (byte)(bytes[n] & 0x7F);
        if (bytes[0] == 0) {
            if (!ByteUtil.isEmpty(bytes)) {
                Global.handleError(FastConstants.R9_STRING_OVERLONG, null);
            }
            if (bytes.length == 1) {
                return null;
            }
            if (bytes.length == 2 && bytes[1] == 0) {
                return new StringValue("");
            }
            if (bytes.length == 3 && bytes[2] == 0) {
                return new StringValue("\u0000");
            }
        }
        return new StringValue(new String(bytes));
    }

    public ScalarValue fromString(String value) {
        return new StringValue(value);
    }

    public ScalarValue getDefaultValue() {
        return new StringValue("");
    }

    public boolean isNullable() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

