% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protFP.R
\name{protFP}
\alias{protFP}
\title{Compute the protFP descriptors of a protein sequence}
\usage{
protFP(seq)
}
\arguments{
\item{seq}{An amino-acids sequence}
}
\value{
The computed average of protFP descriptors of all the amino acids in the corresponding peptide sequence.
}
\description{
The ProtFP descriptor set was constructed from a large initial selection of indices obtained from the AAindex database for all 20 naturally occurring amino acids.
}
\examples{
protFP(seq = "QWGRRCCGWGPGRRYCVRWC")
# [[1]]
# ProtFP1 ProtFP2 ProtFP3 ProtFP4 ProtFP5 ProtFP6 ProtFP7 ProtFP8 
# 0.2065 -0.0565  1.9930 -0.2845  0.7315  0.7000  0.1715  0.1135 
}
\references{
van Westen, G. J., Swier, R. F., Wegner, J. K., IJzerman, A. P., van Vlijmen, H. W., & Bender, A. (2013). Benchmarking of protein descriptor sets in proteochemometric modeling (part 1): comparative study of 13 amino acid descriptor sets. Journal of cheminformatics, 5(1), 41.
}
