% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureEngineering.R
\name{createNormalizer}
\alias{createNormalizer}
\title{Create the settings for normalizing the data @param type The type of normalization to use, either "minmax" or "robust"}
\usage{
createNormalizer(type = "minmax", settings = list())
}
\arguments{
\item{type}{The type of normalization to use, either "minmax" or "robust"}

\item{settings}{A list of settings for the normalization.
For robust normalization, the settings list can contain a boolean value for
clip, which clips the values to be between -3 and 3 after normalization. See
https://arxiv.org/abs/2407.04491}
}
\value{
An object of class \code{featureEngineeringSettings}

An object of class \code{featureEngineeringSettings}'
}
\description{
Create the settings for normalizing the data @param type The type of normalization to use, either "minmax" or "robust"
}
\examples{
# create a minmax normalizer that normalizes the data between 0 and 1
normalizer <- createNormalizer(type = "minmax")
# create a robust normalizer that normalizes the data by the interquartile range
# and squeezes the values to be between -3 and 3
normalizer <- createNormalizer(type = "robust", settings = list(clip = TRUE))
}
