% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_power_curve}
\alias{plot_power_curve}
\title{Examine a power curve (result function)}
\usage{
plot_power_curve(
  pwr,
  plot.points = TRUE,
  all = TRUE,
  low = NULL,
  high = NULL,
  grid.size = 5,
  tnum = 2000,
  breaks = grid.size,
  fit = NULL
)
}
\arguments{
\item{pwr}{pumpresult object or data.frame; result from calling pump_sample or 
pump_mdes (or data frame from, e.g., power_curve()).}

\item{plot.points}{logical; whether to plot individually 
tested points on curve.}

\item{all}{logical; if TRUE, merge in the search path from the
original search.}

\item{low}{scalar; low range for curve.}

\item{high}{scalar; high range for the curve.}

\item{grid.size}{scalar; number of points to calculate power for.}

\item{tnum}{scalar; number of iterations to calculate power at each
grid point.}

\item{breaks}{scalar; the desired number of tick marks on the axes.}

\item{fit}{a four parameter bounded logistic curve 
(if NULL will fit one to passed points).}
}
\value{
plot; a ggplot object of power across values.
}
\description{
This will give a plot of power vs. MDES or sample size. It can
  be useful to see how quickly power changes as a function of these design
  parameters. Can be useful to diagnose relatively flat power curves, where
  power changes little as a function of MDES or sample size, and can also be
  useful to gauge where convergence went poorly.
}
\keyword{internal}
