% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_power_curve}
\alias{plot_power_curve}
\title{Examine a power curve (result function)}
\usage{
plot_power_curve(
  pwr,
  plot.points = TRUE,
  all = TRUE,
  low = NULL,
  high = NULL,
  grid.size = 5,
  tnum = 2000,
  breaks = grid.size,
  fit = NULL
)
}
\arguments{
\item{pwr}{pumpresult object or data.frame; result from calling pump_sample or 
pump_mdes (or data frame from, e.g., power_curve()).}

\item{plot.points}{logical; whether to plot individually 
tested points on curve.}

\item{all}{logical; if TRUE, merge in the search path 
from the original search.}

\item{low}{scalar; low range for the plot x-axis.}

\item{high}{scalar; high range for the plot.}

\item{grid.size}{scalar; number of points to calculate power.}

\item{tnum}{scalar; number of iterations to calculate 
power at each grid point.}

\item{breaks}{scalar; the desired number of tick marks on the axes.}

\item{fit}{a four parameter bounded logistic curve 
(if NULL will fit one to passed points).}
}
\value{
plot; a ggplot object of power across values.
}
\description{
This will give a plot of power vs. MDES or sample size. It can
  be useful to see how quickly power changes as a function of these design
  parameters. Can be useful to diagnose relatively flat power curves, where
  power changes little as a function of MDES or sample size, and can also be
  useful to gauge where convergence went poorly.
}
\examples{
mdes <- pump_mdes(d_m = "d2.1_m2fc", MTP = 'HO',
  power.definition = 'D1indiv', target.power = 0.7,
  J = 60, nbar = 50, M = 3, Tbar = 0.5, alpha = 0.05,
  numCovar.1 = 1, R2.1 = 0.1, ICC.2 = 0.05, rho = 0.2)
plot_power_curve(mdes)
}
