% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dscfAllPairsTest.R
\name{dscfAllPairsTest}
\alias{dscfAllPairsTest}
\alias{dscfAllPairsTest.default}
\alias{dscfAllPairsTest.formula}
\title{Multiple Comparisons of Mean Rank Sums}
\usage{
dscfAllPairsTest(x, ...)

\method{dscfAllPairsTest}{default}(x, g, ...)

\method{dscfAllPairsTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs the all-pairs comparison test for different factor
levels according to Dwass, Steel, Critchlow and Fligner.
}
\details{
For all-pairs comparisons in an one-factorial layout
with non-normally distributed residuals the DSCF
all-pairs comparison test can be used. A total of \eqn{m = k(k-1)/2}
hypotheses can be tested. The null hypothesis
H\eqn{_{ij}: F_i(x) = F_j(x)} is tested in the two-tailed test
against the alternative
A\eqn{_{ij}: F_i(x) \ne F_j(x), ~~ i \ne j}.
As opposed to the all-pairs comparison procedures that depend
on Kruskal ranks, the DSCF test is basically an extension of
the U-test as re-ranking is conducted for each pairwise test.

The p-values are estimated from the studentized range distriburtion.
}
\references{
Douglas, C. E., Fligner, A. M. (1991) On distribution-free multiple
comparisons in the one-way analysis of variance, \emph{Communications in
 Statistics - Theory and Methods} \bold{20}, 127--139.

Dwass, M. (1960) Some k-sample rank-order tests. In \emph{Contributions to
  Probability and Statistics}, Edited by: I. Olkin,
Stanford: Stanford University Press.

Steel, R. G. D. (1960) A rank sum test for comparing all pairs of
treatments, \emph{Technometrics} \bold{2}, 197--207
}
\seealso{
\code{\link{Tukey}}, \code{\link{pairwise.wilcox.test}}
}
\concept{wilcoxonranks}
\keyword{htest}
\keyword{nonparametric}
