% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamesHowellTest.R
\name{gamesHowellTest}
\alias{gamesHowellTest}
\alias{gamesHowellTest.default}
\alias{gamesHowellTest.formula}
\alias{gamesHowellTest.aov}
\title{Games-Howell Test}
\usage{
gamesHowellTest(x, ...)

\method{gamesHowellTest}{default}(x, g, ...)

\method{gamesHowellTest}{formula}(formula, data, subset, na.action, ...)

\method{gamesHowellTest}{aov}(x, ...)
}
\arguments{
\item{x}{a numeric vector of data values, a list of numeric data
vectors or a fitted model object, usually an \link[stats]{aov} fit.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Games-Howell all-pairs comparison test for normally distributed
data with unequal group variances.
}
\details{
For all-pairs comparisons in an one-factorial layout
with normally distributed residuals but unequal between-groups variances
the Games-Howell Test can be performed. A total of \eqn{m = k(k-1)/2}
hypotheses can be tested. The null hypothesis
H\eqn{_{ij}: \mu_i(x) = \mu_j(x)} is tested in the two-tailed test
against the alternative
A\eqn{_{ij}: \mu_i(x) \ne \mu_j(x), ~~ i \ne j}.

The p-values are computed from the studentized range distribution.
}
\examples{
fit <- aov(weight ~ feed, chickwts)
shapiro.test(residuals(fit))
bartlett.test(weight ~ feed, chickwts) # var1 = varN
anova(fit)

## also works with fitted objects of class aov
res <- gamesHowellTest(fit)
summary(res)
summaryGroup(res)
}
\seealso{
\code{\link{ptukey}}
}
\concept{parametric}
\keyword{htest}
