% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateAverageSpectra.R
\name{calculateAverageSpectra}
\alias{calculateAverageSpectra}
\title{Calculate Average Spectra of Clicks}
\usage{
calculateAverageSpectra(
  x,
  evNum = 1,
  calibration = NULL,
  wl = 1024,
  filterfrom_khz = 0,
  filterto_khz = NULL,
  sr = NULL,
  norm = TRUE,
  plot = TRUE
)
}
\arguments{
\item{x}{an \linkS4class{AcousticEvent} or \linkS4class{AcousticStudy} object}

\item{evNum}{if \code{x} is a study, the event number to calculate the average
spectra for}

\item{calibration}{a calibration function to apply, if desired}

\item{wl}{the size of the click clips to use for calculating the spectrum. If
greater than the clip present in the binary, clip will be zero padded}

\item{filterfrom_khz}{frequency in khz of highpass filter to apply, or the lower
bound of a bandpass filter if \code{filterto_khz} is not \code{NULL}}

\item{filterto_khz}{if a bandpass filter is desired, set this as the upper bound.
If only a highpass filter is desired, leave as the default \code{NULL} value.
Currently only highpass and bandpass filters are supported, so if
\code{filterfrom_khz} is left as zero then this parameter will have no effect}

\item{sr}{a sample rate to use if the sample rate present in the database needs
to be overridden (typically only needed if a decimator was used)}

\item{norm}{logical flag to normalize magnitudes to 0-1 range}

\item{plot}{logical flag whether or not to plot the result. The plot will be a
two panel plot, the top is a concatenated spectrogram where the y-axis is
frequency and the x-axis is click number. The bottom plot is the average
spectrogram of all clicks, the y-axis is normalized magnitude (dB values
for each click are normalized between 0 and 1 before averaging), x-axis
is frequency.}
}
\value{
invisibly returns a list with three items: \code{freq}, the frequency,
  \code{average}, the average spectra of the event, and \code{all}, the individual
  spectrum of each click in the event as a matrix.
}
\description{
Calculates the average spectra of all the clicks present in an
  event
}
\examples{

data(exStudy)
# need to update binary file locations to users PAMpal installation
binUpd <- system.file('extdata', 'Binaries', package='PAMpal')
dbUpd <- system.file('extdata', package='PAMpal')
exStudy <- updateFiles(exStudy, bin = binUpd, db=dbUpd)
avSpec <- calculateAverageSpectra(exStudy)
str(avSpec$average)
range(avSpec$freq)
str(avSpec$all)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
