% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim_rKJ.R
\name{Sim_rKJ}
\alias{Sim_rKJ}
\title{Calculate Empirical Power by Simulation for the Optimal Two-Stage Design Using
One-Sample Log-Rank Test with Restricted Follow-Up}
\usage{
Sim_rKJ(dist, shape, S0, S1, x0, x, rate, t1, c1, c, n1, n, N, seed = 123)
}
\arguments{
\item{dist}{distribution options with 'WB' as Weibull, 'GM' as Gamma,
'LN' as log-normal, 'LG' as log-logistic for the baseline hazard function.}

\item{shape}{shape parameter of the baseline hazard function assuming one of the four possible parametric distributions ('WB', 'GM',
'LN' and 'LG').}

\item{S0}{survival probability at a fixed time point x0 under the null hypothesis.}

\item{S1}{survival probability at a fixed time point x0 under the alternative hypothesis.}

\item{x0}{a fixed time point where the survival probabilities are known for both
null and alternative hypotheses.}

\item{x}{the restricted follow-up time period.}

\item{rate}{a constant accrual rate.}

\item{t1}{the interim analysis time in the two-stage design.\cr}

\item{c1}{the critical value in two-stage designs for the interim analysis.}

\item{c}{the critical value in two-stage designs for the final analysis.\cr}

\item{n1}{the required sample size in the two-stage design for the interim analysis.}

\item{n}{the required sample size in the two-stage design for the final stage.\cr}

\item{N}{number of trials in the simulation.}

\item{seed}{seed for random number generation.}
}
\value{
a numeric value that is either the empirical power (when S1=S0^hr) or the type I-error (when S1=S0).
}
\description{
Sim_rKJ() can be used to calculate empirical power and type-I error by simulation
given the design parameters (e.g., n1, n, c1, c) obtained from the optimal two-stage design with
restricted follow-up.
}
\examples{
\donttest{Design3 <- Optimal.rKJ(dist="WB", shape=0.5, S0=0.3, x0=1, hr=0.65, x=1, rate=10,
alpha=0.05, beta=0.2)}
# Design3$Two_stage
# n1     c1      n    c      t1      MTSL   ES      PS
# 38     0.1688  63   1.6306 3.7084  7.3    48.3058 0.567

# calculate empirical power and type I error given the above design parameters
Sim_rKJ(dist="WB", shape=0.5, S0=0.3, S1=0.3^(0.65), x0=1, x=1, rate=10, t1=3.7084,
    c1=0.1688, c=1.6306, n1=38, n=63, N=10000, seed=5868)
# empirical power
# 0.796

Sim_rKJ(dist="WB", shape=0.5, S0=0.3, S1=0.3, x0=1, x=1, rate=10, t1=3.7084,
    c1=0.1688, c=1.6306, n1=38, n=63, N=10000, seed=5868)
# empirical type-I error
# 0.041
}
