% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{ISMorrill}
\alias{ISMorrill}
\title{A function to compute Morrill's segregation index}
\usage{
ISMorrill(x, c = NULL, queen = TRUE, 
spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a population group, within 
spatial units. The number of columns should be greater than 1 (at least 2 
population groups are required). You should not include a column with total 
population in each unit, because this will be interpreted as a group.}

\item{c}{- a standard binary contiguity (adjacency) symmetric matrix where 
each element \emph{Cij} equals 1 if \emph{i}-th and \emph{j}-th spatial 
units are adjacent, and 0 otherwise.}

\item{queen}{- logical parameter difining criteria used for contiguity 
matrix computation, TRUE (by default) for queen , FALSE for rook}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame) containing 
geographic information}

\item{folder}{- a character vector with the folder (directory) 
name indicating where the shapefile with the geographic information 
is located.}

\item{shape}{- a character vector with the name of the shapefile 
(without the .shp extension)  which contains the geographic information}
}
\value{
a numeric vector containing the Morrill's segregation index value for 
each population group
}
\description{
Morrill's segregation index is a development of 
\code{\link{ISDuncan}}'s index which takes into account the 
interactions between spatial units (contiguity). 
The function can be used in two ways: to provide a contiguity 
matrix or a external geographic information source (spatial object 
or shape file).
}
\examples{
x <- segdata@data[ ,1:2]
contiguity <- contig(segdata)
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'

ISMorrill(x, c = contiguity) 

ISMorrill(x, spatobj = segdata)

ISMorrill(x, folder = foldername, shape = shapename) 

}
\references{
Morrill B. (1991) \emph{On the measure of geographic 
segregation}. Geography research forum, 11, pp. 25-36.
}
\seealso{
One-group evenness indices: 
\code{\link{ISDuncan}}, \code{\link{Gini}}, \code{\link{Gorard}}, 
\code{\link{HTheil}}, \code{\link{Atkinson}}, '\code{\link{ISWong}}

Between groups dissimilarity indices: 
\code{\link{DIDuncan}}, \code{\link{Gini2}}, 
\code{\link{DIMorrill}}, \code{\link{DIWong}}
}

