% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modues.R
\name{varmlp}
\alias{varmlp}
\title{Artificial Neural Network VAR (Vector Auto-Regressive) model using a MultiLayer Perceptron.}
\usage{
varmlp(df, lag, sizeOfHLayers, iters, bias = TRUE)
}
\arguments{
\item{df}{A numerical dataframe}

\item{lag}{The lag parameter}

\item{sizeOfHLayers}{Integer vector that contains the size of hidden layers (the number of hidden layers is the size of this vector)}

\item{iters}{The number of iterations}

\item{bias}{Logical, true if the bias have to be used in the network}
}
\value{
train (df):  updates the model using the input dataframe df

forecast (df):  returns the next row forecasts of an given dataframe df
}
\description{
Artificial Neural Network VAR (Vector Auto-Regressive) model using a MultiLayer Perceptron.
}
\details{
This function constructs the model.
}
\examples{
library (timeSeries) # to extract time series
library (NlinTS)
#load data
data = LPP2005REC
# Prepare data to make one forecasts
train_data = head (data, nrow (data) - 1)
test_data = tail (data, 1)
model = varmlp (train_data, 1, c(10,5), 200, TRUE)
predictions = model$forecast (train_data)
print (tail (predictions,1))
# Update the model (learning from new data)
model$train (test_data)
}
